% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BSBPlotSumm.R
\name{BSBPlotSumm}
\alias{BSBPlotSumm}
\title{Plot summaries for BSBHaz model}
\usage{
BSBPlotSumm(bsbhaz, variable = c("lambda1", "lambda2", "s1", "s2"))
}
\arguments{
\item{bsbhaz}{An object of class 'BSBHaz' created by
\code{\link{BSBHaz}}.}

\item{variable}{A character indicating the variable to plot.}
}
\description{
Plot summaries for BSBHaz model
}
\examples{
t1 <- survival::Surv(c(1, 2, 3))
t2 <- survival::Surv(c(1, 2, 3))

init <- BSBInit(t1 = t1, t2 = t2, seed = 0)
samples <- BSBHaz(init, iter = 10, omega_d = 2,
gamma_d = 10, seed = 10)

BSBPlotSumm(samples, "s1")
}
