% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/install.R
\name{use_bertopic_condaenv}
\alias{use_bertopic_condaenv}
\title{Bind current R session to a BERTopic Conda environment}
\usage{
use_bertopic_condaenv(envname = "r-bertopic", required = TRUE)
}
\arguments{
\item{envname}{Character. Conda env name (default \code{"r-bertopic"}).}

\item{required}{Logical. Kept for API symmetry; unused.}
}
\value{
Invisibly returns the Python executable path in the env.
}
\description{
Sets \code{RETICULATE_PYTHON} to the environment's Python and initializes
\pkg{reticulate}. If \pkg{reticulate} is already initialized to a different
Python, this stops with an informative error.
}
\examples{
\dontrun{
use_bertopic_condaenv("r-bertopic")
}
}
