% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/bekk_fit.R
\name{bekk_fit}
\alias{bekk_fit}
\title{Estimating multivariate BEKK-type volatility models}
\usage{
bekk_fit(spec, data, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-09)
}
\arguments{
\item{spec}{An object of class "bekkSpec" from function \link{bekk_spec}.}

\item{data}{A multivariate data object. Can be a numeric matrix or ts/xts/zoo object.}

\item{QML_t_ratios}{Logical. If QML_t_ratios = 'TRUE', the t-ratios of the BEKK parameter matrices
are exactly calculated via second order derivatives.}

\item{max_iter}{Maximum number of BHHH algorithm iterations.}

\item{crit}{Determines the precision of the BHHH algorithm.}
}
\value{
Returns a S3 class "bekkFit" object containing the estimated parameters, t-values, standard errors and volatility process of the model defined by the BEKK_spec object.
}
\description{
Method for fitting a variety of N-dimensional BEKK models.
}
\details{
The BEKK optimization routine is based on the Berndt–Hall–Hall–Hausman (BHHH) algorithm and is inspired by the study of Hafner and Herwartz (2008).
The authors provide analytical formulas for the score and Hessian of several MGARCH models in a QML framework and show that analytical derivations significantly outperform numerical methods.
}
\examples{
\donttest{

data(StocksBonds)

# Fitting a symmetric BEKK model
obj_spec <- bekk_spec()
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

summary(x1)

plot(x1)

# Fitting an asymmetric BEKK model
obj_spec <- bekk_spec(model = list(type = "bekk", asymmetric = TRUE))
x1 <- bekk_fit(obj_spec, StocksBonds)

summary(x1)

plot(x1)

# Fitting a symmetric diagonal BEKK model
obj_spec <- bekk_spec(model = list(type = "dbekk", asymmetric = FALSE))
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

summary(x1)

plot(x1)


# Fitting a symmetric scalar BEKK model
obj_spec <- bekk_spec(model = list(type = "sbekk", asymmetric = FALSE))
x1 <- bekk_fit(obj_spec, StocksBonds, QML_t_ratios = FALSE, max_iter = 50, crit = 1e-9)

summary(x1)

plot(x1)

}
}
\references{
Hafner and Herwartz (2008). Analytical quasi maximum likelihood inference in multivariate volatility models. Metrika, 67, 219-239.

Fülle, M. J., A. Lange, C. M. Hafner, and H. Herwartz (2024). BEKKs: An R package for estimation of
conditional volatility of multivariate time series. Journal of Statistical Software 111 (4), 1–34. <doi:10.18637/jss.v111.i04>.
}
