% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get_net_rtg_on_off.R
\name{get_net_rtg_on_off}
\alias{get_net_rtg_on_off}
\title{Net Rating On/Off}
\usage{
get_net_rtg_on_off(data_combs, team_name, type_lineup, type_period, type_opponent, 
                   filter_players, language, asp_ratio = 1)
}
\arguments{
\item{data_combs}{Data frame with all the combinations of lineups.}

\item{team_name}{Name of the team.}

\item{type_lineup}{Type of lineups to analyze. Options are 'quintet', 'quartet', 'trio',
'duo' and 'single'.}

\item{type_period}{Period of interest. Options are xC, where x starts from 1. 
Common periods are from 1 to 4. Overtimes are labeled with the next numbers, such as 5C 
for the first overtime and 6C for the second one. Nothing to do if NULL.}

\item{type_opponent}{Name of the opponent teams. Nothing to do if NULL.}

\item{filter_players}{String with the players' names to filter. Nothing to do if NULL.}

\item{language}{Language of the legends and titles.}

\item{asp_ratio}{Aspect ratio of the plot. Default 1.}
}
\value{
A plot with the players' net ratings and differentials.
}
\description{
The Net Rating On/Off measures a team's net rating when a specific player is on the court versus 
when they are on the bench. It highlights the player's impact by comparing the team's efficiency 
both in offense and defense. A positive differential indicates a positive, higher-impact player.
}
\details{
\itemize{
\item Net Rating: difference between Offensive Rating and Defensive Rating.
\item On-Court Rating: team's net rating while the player is in the game.
\item Off-Court Rating: team's net rating while the player is on the bench.
\item On/Off Differential: difference between the on-court and off-court net ratings, 
which gives a first idea of how much better/worse the team performs with that player.
}
}
\examples{
\dontrun{
get_net_rtg_on_off(acb_combs, "Unicaja", "single", NULL, NULL, NULL, "Spanish")
}

}
\seealso{
\code{\link{do_possession_stats_lineup}}
}
\author{
Guillermo Vinue
}
