% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lm_plot.ac.R
\name{lm_plot.ac}
\alias{lm_plot.ac}
\title{Plot Residuals vs. Observation Order (Autocorrelation Check)}
\usage{
lm_plot.ac(
  mdl,
  ...,
  pval.DW = FALSE,
  parms = lm_plot.parms(mdl),
  df = lm_plot.df(mdl, parms = parms)
)
}
\arguments{
\item{mdl}{A fitted model object (typically from \code{\link[stats]{lm}}).}

\item{...}{Additional arguments (not currently used).}

\item{pval.DW}{(logical, default = FALSE) Option to show Durbin-Watson p-value on the plot.}

\item{parms}{A list of plotting parameters, usually from \code{lm_plot.parms()}.}

\item{df}{Data frame with augmented model data. Defaults to \code{lm_plot.df(mdl)}.}
}
\value{
A \code{ggplot} object representing the residuals vs. order plot. Included as an attribute \code{"parm"} is a list containing:
\itemize{
  \item \code{lim} Plotted limits on \code{x} and \code{y} axes,
  \item \code{pval.DW} Option to show Durbin-Watson p-value,
  \item \code{DW} The \code{htest} object with Durbin-Watson test results.
}
}
\description{
Creates a plot of residuals against the sequence/order of observations to visually assess independence and detect autocorrelation. Outliers are labeled by default. Optionally includes p-value result from the Durbin–Watson test for autocorrelation.
}
\details{
Points are colored and shaped according to whether they are residual outliers
(as determined by Tukey's boxplot rule). The function can label points using
\pkg{ggrepel} if \code{parm$pts$id$outl} or \code{parm$pts$id$reg} are set to \code{TRUE}.
}
\examples{
fit <- lm(res ~ ., data = data.frame(time = time(austres), res = austres))
lm_plot.ac(fit, pval.DW = TRUE)

}
\seealso{
\code{\link[lmtest]{dwtest}}, \code{\link{lm_plot.df}}, \code{\link{lm_plot.parms}}
}
