% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vm2_mle.R
\name{vm2_mle}
\alias{vm2_mle}
\title{Maximum likelihood estimation of bivariate von Mises parameters}
\usage{
vm2_mle(data, model = c("vmsin", "vmcos"), ...)
}
\arguments{
\item{data}{data matrix (if bivarate, in which case it must have two columns) or vector. If outside, the values
are transformed into the scale \eqn{[0, 2\pi)}. *Note:* BAMBI cannot handle missing data. Missing values must
either be removed or properly imputed.}

\item{model}{Bivariate von Mises model. One of "vmsin", "vmcos" or "indep".}

\item{...}{Additional arguments. See details.}
}
\value{
An object of class \link{mle-class}.
}
\description{
Maximum likelihood estimation of bivariate von Mises parameters
}
\details{
The parameters \code{kappa1} and \code{kappa2} are optimized
in log scales. The method of optimization used (passed to \link{optim})
can be specified through \code{method} in \code{...}
(defaults to \code{"L-BFGS-B"}). Note, however, that
lower (0)  and upper (2*pi) bounds for \code{mu1} and \code{mu2}
are specified; so not all methods implemented in \link{optim} will work.
}
\examples{
pars <- list(kappa1 = 3, kappa2 = 2, kappa3 = 1.5, mu1 = 0.5, mu2 = 1.5)
nsamp <- 2000
model <- "vmsin"
set.seed(100)
dat_gen <- do.call(paste0("r", model), c(list(n = nsamp), pars))

est <- vm2_mle(dat_gen, model = model)
library(stats4)
coef(est)
vcov(est)
}
