% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BALLI.v0.2.R
\name{tecVarEstim}
\alias{tecVarEstim}
\title{Technical Variance Estimation}
\usage{
tecVarEstim(counts, design = NULL, lib.size = NULL, span = 0.5, ...)
}
\arguments{
\item{counts}{a DGEList object}

\item{design}{design matrix with samples in row and coefficient(s) to be estimated in column}

\item{lib.size}{numeric vector containing total library sizes for each sample}

\item{span}{width of the lowess smoothing window as a proportion}

\item{...}{other arguments are passed to lmFit.}
}
\value{
an TecVarList object with the following components:
\item{targets}{matrix containing covariables, library sizes and normalization foctors of each sample}
\item{design}{design matrix with samples in row and covariable(s) to be estimated in column}
\item{logcpm}{logcpm values of each gene and each sample}
\item{tecVar}{estimated techical variance of each gene and each sample}
}
\description{
Estimate technical variance by using voom-trend. The code is derived from voom function in limma package
}
\examples{
expr <- data.frame(t(sapply(1:1000,function(x)rnbinom(20,mu=500,size=50))))
group <- c(rep("A",10),rep("B",10))
design <- model.matrix(~group, data = expr)
dge <- DGEList(counts=expr, group=group)
dge <- calcNormFactors(dge)
tecVarEstim(dge,design)
}
