% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/endpoint.R
\name{cosmos_endpoint}
\alias{cosmos_endpoint}
\alias{call_cosmos_endpoint}
\alias{process_cosmos_response}
\alias{process_cosmos_response.response}
\alias{process_cosmos_response.list}
\title{Client endpoint for Azure Cosmos DB core API}
\usage{
cosmos_endpoint(
  host,
  key,
  key_type = c("master", "resource"),
  api_version = getOption("azure_cosmosdb_api_version")
)

call_cosmos_endpoint(
  endpoint,
  path,
  resource_type,
  resource_link,
  options = list(),
  headers = list(),
  body = NULL,
  encode = "json",
  do_continuations = TRUE,
  http_verb = c("GET", "DELETE", "PUT", "POST", "PATCH", "HEAD"),
  num_retries = 10,
  ...
)

process_cosmos_response(response, ...)

\method{process_cosmos_response}{response}(
  response,
  http_status_handler = c("stop", "warn", "message", "pass"),
  return_headers = NULL,
  simplify = FALSE,
  ...
)

\method{process_cosmos_response}{list}(
  response,
  http_status_handler = c("stop", "warn", "message", "pass"),
  return_headers = NULL,
  simplify = FALSE,
  ...
)
}
\arguments{
\item{host}{For \code{cosmos_endpoint}, the host URL for the endpoint. Typically of the form \verb{https://\{account-name\}.documents.azure.com:443/} (note the port number).}

\item{key}{For \code{cosmos_endpoint}, a string containing the password for the endpoint. This can be either a master key or a resource token.}

\item{key_type}{For \code{cosmos_endpoint}, the type of the key, either "master" or "resource".}

\item{api_version}{For \code{cosmos_endpoint}, the API version to use.}

\item{endpoint}{For \code{call_cosmos_endpoint}, a Cosmos DB endpoint object, as returned by \code{cosmos_endpoint}.}

\item{path}{For \code{call_cosmos_endpoint}, the path in the URL for the endpoint call.}

\item{resource_type}{For \code{call_cosmos_endpoint}, the type of resource: for example, "dbs" for a database, "colls" for a collection (container), "docs" for a document, etc.}

\item{resource_link}{For \code{call_cosmos_endpoint}, a string to pass to the API for authorization purposes. See the Cosmos DB API documentation for more information.}

\item{options}{For \code{call_cosmos_endpoint}, query options to include in the request URL.}

\item{headers}{For \code{call_cosmos_endpoint}, any HTTP headers to include in the request. You don't need to include authorization headers as \code{call_cosmos_endpoint} will take care of the details.}

\item{body}{For \code{call_cosmos_endpoint}, the body of the request if any.}

\item{encode}{For \code{call_cosmos_endpoint}, the encoding (really content-type) of the request body. The Cosmos DB REST API uses JSON, so there should rarely be a need to change this argument.}

\item{do_continuations}{For \code{call_cosmos_endpoint}, whether to automatically handle paged responses. If FALSE, only the initial response is returned.}

\item{http_verb}{For \code{call_cosmos_endpoint}, the HTTP verb for the request. One of "GET", "POST", "PUT", "PATCH", "HEAD" or "DELETE".}

\item{num_retries}{For \code{call_cosmos_endpoint}, how many times to retry a failed request. Useful for dealing with rate limiting issues.}

\item{...}{Arguments passed to lower-level functions.}

\item{response}{For \code{process_cosmos_response}, the returned object from a \code{call_cosmos_endpoint} call. This will be either a single httr request object, or a list of such objects.}

\item{http_status_handler}{For \code{process_cosmos_response}, the R handler for the HTTP status code of the response.  "stop", "warn" or "message" will call the corresponding handlers in httr, while "pass" ignores the status code. The latter is primarily useful for debugging purposes.}

\item{return_headers}{For \code{process_cosmos_response}, whether to return the headers from the response object(s), as opposed to the body. Defaults to TRUE if the original endpoint call was a HEAD request, and FALSE otherwise.}

\item{simplify}{For \code{process_cosmos_response}, whether to convert arrays of objects into data frames via the \code{simplifyDataFrame} argument to \link[jsonlite:fromJSON]{jsonlite::fromJSON}.}
}
\value{
For \code{cosmos_endpoint}, an object of S3 class \code{cosmos_endpoint}.

For \code{call_cosmos_endpoint}, either a httr response object, or a list of such responses (if a paged query, and \code{do_continuations} is TRUE).

For \code{process_cosmos_response} and a single response object, the content of the response. This can be either the parsed response body (if \code{return_headers} is FALSE) or the headers (if \code{return_headers} is TRUE).

For \code{process_cosmos_response} and a list of response objects, a list containing the individual contents of each response.
}
\description{
Client endpoint for Azure Cosmos DB core API
}
\details{
These functions are the basis of the SQL API client framework provided by AzureCosmosR. The \code{cosmos_endpoint} function returns a client object, which can then be passed to other functions for querying databases and containers. The \code{call_cosmos_endpoint} function sends calls to the REST endpoint, the results of which are then processed by \code{process_cosmos_response}.

In most cases, you should not have to use \code{call_cosmos_endpoint} directly. Instead, use \code{do_cosmos_op} which provides a slightly higher-level interface to the API, by providing sensible defaults for the \code{resource_type} and\code{resource_link} arguments and partially filling in the request path.

As an alternative to AzureCosmosR, you can also use the ODBC protocol to interface with the SQL API. By installing a suitable ODBC driver, you can then talk to Cosmos DB in a manner similar to other SQL databases. An advantage of the ODBC interface is that it fully supports cross-partition queries, unlike the REST API. A disadvantage is that it does not support nested document fields; functions like \code{array_contains()} cannot be used, and attempts to reference arrays and objects may return incorrect results.

Note that AzureCosmosR is a framework for communicating directly with the \emph{core} Cosmos DB client API, also known as the "SQL" API. Cosmos DB provides other APIs as options when creating an account, such as Cassandra, MongoDB, table storage and Gremlin. These APIs are not supported by AzureCosmosR, but you can use other R packages for working with them. For example, you can use AzureTableStor to work with the table storage API, or mongolite to work with the MongoDB API.
}
\examples{
\dontrun{

endp <- cosmos_endpoint("https://myaccount.documents.azure.com:443/", key="mykey")

# properties for the Cosmos DB account
call_cosmos_endpoint(endp, "", "", "") \%>\%
    process_cosmos_response()

}
}
\seealso{
\link{do_cosmos_op}, \link{cosmos_database}, \link{cosmos_container}, \link{az_cosmosdb}

\link[httr:VERB]{httr::VERB}, which is what carries out the low-level work of sending the HTTP request.
}
