% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotFunctions.R
\name{Plot.ConfusionMatrix}
\alias{Plot.ConfusionMatrix}
\title{Plot.ConfusionMatrix}
\usage{
Plot.ConfusionMatrix(
  dt = NULL,
  PreAgg = FALSE,
  XVar = NULL,
  YVar = NULL,
  ZVar = "N",
  YVarTrans = "Identity",
  XVarTrans = "Identity",
  ZVarTrans = "Identity",
  FacetRows = 1,
  FacetCols = 1,
  FacetLevels = NULL,
  NumberBins = 21,
  NumLevels_X = 50,
  NumLevels_Y = 50,
  Height = NULL,
  Width = NULL,
  Title = "Confusion Matrix",
  ShowLabels = FALSE,
  Title.YAxis = NULL,
  Title.XAxis = NULL,
  EchartsTheme = "macarons",
  MouseScroll = TRUE,
  TimeLine = TRUE,
  TextColor = "white",
  AggMethod = "count",
  GroupVar = NULL,
  xaxis.rotate = 0,
  yaxis.rotate = 0,
  ContainLabel = TRUE,
  Debug = FALSE
)
}
\arguments{
\item{dt}{source data.table}

\item{PreAgg}{FALSE}

\item{XVar}{Column name of X-Axis variable. If NULL then ignored}

\item{YVar}{Column name of Y-Axis variable. If NULL then ignored}

\item{ZVar}{= "N"}

\item{YVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{XVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{ZVarTrans}{"Asinh", "Log", "LogPlus1", "Sqrt", "Asin", "Logit", "PercRank", "Standardize", "BoxCox", "YeoJohnson"}

\item{FacetRows}{Defaults to 1 which causes no faceting to occur vertically. Otherwise, supply a numeric value for the number of output grid rows}

\item{FacetCols}{Defaults to 1 which causes no faceting to occur horizontally. Otherwise, supply a numeric value for the number of output grid columns}

\item{FacetLevels}{Faceting rows x columns is the max number of levels allowed in a grid. If your GroupVar has more you can supply the levels to display.}

\item{NumberBins}{= 21,}

\item{NumLevels_X}{= NumLevels_Y,}

\item{NumLevels_Y}{= NumLevels_X,}

\item{Height}{"400px"}

\item{Width}{"200px"}

\item{Title}{title}

\item{ShowLabels}{character}

\item{Title.YAxis}{character}

\item{Title.XAxis}{character}

\item{EchartsTheme}{"auritus","azul","bee-inspired","blue","caravan","carp","chalk","cool","dark-bold","dark","eduardo", #' "essos","forest","fresh-cut","fruit","gray","green","halloween","helianthus","infographic","inspired", #' "jazz","london","dark","macarons","macarons2","mint","purple-passion","red-velvet","red","roma","royal", #' "sakura","shine","tech-blue","vintage","walden","wef","weforum","westeros","wonderland"}

\item{MouseScroll}{logical, zoom via mouse scroll}

\item{TimeLine}{logical}

\item{TextColor}{'darkblue'}

\item{AggMethod}{Choose from 'mean', 'sum', 'sd', and 'median'}

\item{GroupVar}{= NULL}

\item{xaxis.rotate}{numeric}

\item{yaxis.rotate}{numeric}

\item{ContainLabel}{logical}

\item{Debug}{Debugging purposes}
}
\value{
plot
}
\description{
Generate variable importance plots
}
\seealso{
Other Model Evaluation: 
\code{\link{Plot.BinaryMetrics}()},
\code{\link{Plot.Calibration.Box}()},
\code{\link{Plot.Calibration.Line}()},
\code{\link{Plot.Gains}()},
\code{\link{Plot.Lift}()},
\code{\link{Plot.PartialDependence.Box}()},
\code{\link{Plot.PartialDependence.HeatMap}()},
\code{\link{Plot.PartialDependence.Line}()},
\code{\link{Plot.ROC}()},
\code{\link{Plot.Residuals.Histogram}()},
\code{\link{Plot.Residuals.Scatter}()},
\code{\link{Plot.ShapImportance}()},
\code{\link{Plot.VariableImportance}()}
}
\author{
Adrian Antico
}
\concept{Model Evaluation}
