### Creating functions for calculating statistics of automated advertisement
view_percent <- function(data){
  x <- data$Impressions
  y <- data$Viewable
  round(
    y/x*100,
    digits=2)
}

eCPM <- function(data){
  x <- data$Impressions
  y <- data$Revenue
  round(
    y/x*1000,
    digits=2)
}

CPMv <- function(data){
  x <- data$Viewable
  y <- data$Revenue
  round(
    y/x*1000,
    digits=2)
}

CTR <- function(data){
  x <- data$Impressions
  y <- data$Clicks
  round(
    y/x,
    digits=2)
}

CPC <- function(data){
  x <- data$Clicks
  y <- data$Revenue
  round(
    y/x,
    digits=2)
}

fill_rate <- function(data){
  x <- data$Requests
  y <- data$Impressions
  round(
    y/x*100,
    digits=2)
}

### Downloading a sample (Also possible as excel or other file)
data <- data.frame(
  Date = c("2022-07-01", "2022-07-02", "2022-07-03", "2022-07-04", "2022-07-05", "2022-07-06", "2022-07-07", "2022-07-08", "2022-07-09", "2022-07-10", "2022-07-11", "2022-07-12", "2022-07-13", "2022-07-14", "2022-07-15", "2022-07-16", "2022-07-17", "2022-07-18", "2022-07-19", "2022-07-20", "2022-07-21", "2022-07-22", "2022-07-23", "2022-07-24", "2022-07-25", "2022-07-26", "2022-07-27", "2022-07-28", "2022-07-29", "2022-07-30", "2022-07-31", "2022-07-01", "2022-07-02", "2022-07-03", "2022-07-04", "2022-07-05", "2022-07-06", "2022-07-07", "2022-07-08", "2022-07-09", "2022-07-10", "2022-07-11", "2022-07-12", "2022-07-13", "2022-07-14", "2022-07-15", "2022-07-16", "2022-07-17", "2022-07-18", "2022-07-19", "2022-07-20", "2022-07-21", "2022-07-22", "2022-07-23", "2022-07-24", "2022-07-25", "2022-07-26", "2022-07-27", "2022-07-28", "2022-07-29", "2022-07-30", "2022-07-31"),
  Block = c("1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_234", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235", "1_235"),
  Requests = c(372234, 268816, 291224, 399109, 383962, 382214, 389865, 365455, 281391, 291740, 388472, 381215, 372994, 375715, 372318, 280157, 290029, 398011, 382938, 386224, 376212, 355127, 274288, 282119, 374851, 378399, 379820, 372036, 354963, 278810, 304971, 1108755, 1848347, 1790694, 1784609, 1682512, 1068344, 1093918, 1881346, 1868104, 1784772, 1757443, 1647247, 1033891, 1092752, 1862124, 1844850, 1765838, 1760493, 1650159, 1067656, 1166593, 1931007, 1822504, 1824652, 1818503, 1656483, 1086639, 1100089, 1928854, 1928290, 786539),
  Impressions = c(18537, 12432, 13764, 12987, 14541, 11544, 23088, 24753, 20091, 18759, 22422, 27861, 36741, 44733, 37185, 20091, 16317, 31191, 38184, 54279, 48507, 18648, 8325, 11433, 14652, 17982, 90909, 146631, 130647, 34521, 9990, 65268, 471195, 357309, 289155, 328671, 249750, 301476, 2901096, 3299364, 2271726, 1615383, 2631366, 951936, 736263, 2611608, 2984235, 1724829, 1955931, 1957818, 1286712, 1813074, 4187253, 5306910, 5449212, 2508822, 1784436, 761571, 825507, 2839269, 2682648, 1114773),
  Revenue = c(13.5, 9.13, 8.85, 8.42, 9.35, 7.29, 16.3, 16.7, 14.3, 12.4, 14.5, 17.6, 24.4, 26.0, 26.6, 16.4, 14.5, 20.8, 24.2, 31.7, 27.8, 16.1, 6.08, 7.98, 11.3, 12.3, 48.1, 73.6, 65.7, 19.1, 5.4, 53.1, 538.0, 397.0, 285.0, 294.0, 187.0, 231.0, 1868.0, 1971.0, 1374.0, 1231.0, 2418.0, 815.0, 849.0, 2567.0, 2195.0, 1192.0, 1306.0, 1247.0, 814.0, 1106.0, 3909.0, 5836.0, 4530.0, 1390.0, 1051.0, 467.0, 487.0, 1669.0, 1654.0, 739.0),
  Clicks = c(1167, 720, 856, 817, 1031, 749, 1566, 1527, 1128, 1128, 1518, 2004, 2588, 3171, 2452, 1274, 1167, 2072, 2773, 3668, 3541, 1128, 545, 759, 895, 1265, 6868, 11061, 9709, 2481, 710, 4816, 35294, 26860, 22288, 23328, 18542, 22550, 227428, 252819, 174866, 125359, 202524, 72262, 56191, 198243, 229296, 130349, 145457, 145934, 94403, 133005, 327065, 409989, 416926, 191151, 134727, 58088, 63137, 214451, 196657, 93178),
  Viewable = c(13320, 8214, 9768, 9324, 11766, 8547, 17871, 17427, 12876, 12876, 17316, 22866, 29526, 36186, 27972, 14541, 13320, 23643, 31635, 41847, 40404, 12876, 6216, 8658, 10212, 14430, 78366, 126207, 110778, 28305, 8103, 54945, 402708, 306471, 254301, 266178, 211566, 257298, 2594958, 2884668, 1995225, 1430346, 2310798, 824508, 641136, 2261958, 2616270, 1487289, 1659672, 1665111, 1077144, 1517592, 3731820, 4677984, 4757127, 2181039, 1537239, 662781, 720390, 2446884, 2243865, 1063158)
)

### Adding results of calculations to the sample
data$ViewablePercent <- view_percent(data)
data$eCPM <- eCPM(data)
data$CPMv <- CPMv(data)
data$CTR <- CTR(data)
data$CPC <- CPC(data)
data$FillRate <- fill_rate(data)

### Creating a function that will use all the metrics together
adstats <- function(data){
  data$ViewablePercent <- view_percent(data)
  data$eCPM <- eCPM(data)
  data$CPMv <- CPMv(data)
  data$CTR <- CTR(data)
  data$CPC <- CPC(data)
  data$FillRate <- fill_rate(data)
  data
}
data <- adstats(data)

### Plotting
globalVariables(c("Date", "Forecast"))
plot_trend_and_forecast <- function(data, x_col, y_col, group_col) {
  data$Date <- as.Date(data$Date)
  data_groups <- split(data, data[[group_col]])
  for (group in names(data_groups)) {
    group_data <- data_groups[[group]]
    time_series <- ts(group_data[[y_col]], frequency = 1, start = min(group_data[[x_col]]))
    arima_model <- auto.arima(time_series)
    forecast <- forecast(arima_model, h = 6)
    forecast_dates <- seq(max(group_data[[x_col]]) + 1,
                          to = max(group_data[[x_col]]) + length(forecast$mean),
                          by = "day")
    forecast_data <- data.frame(Date = forecast_dates, Forecast = forecast$mean)
    print(ggplot() +
            geom_line(data = group_data, aes(x = !!rlang::sym(x_col), y = !!rlang::sym(y_col))) +
            geom_line(data = forecast_data, aes(x = Date, y = Forecast), color = "blue") +
            geom_ribbon(data = forecast_data, aes(x = Date, ymin = forecast$lower[, 2],
                                                  ymax = forecast$upper[, 2]), fill = "blue", alpha = 0.2) +
            labs(x = x_col, y = y_col, title = group) +
            theme_minimal())
  }
}
plot_trend_and_forecast(data, "Date", "eCPM", "Block") #Any value instead of Impressions can be here
