% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zoonPredict.R
\name{ZoonModel}
\alias{ZoonModel}
\title{ZoonModel}
\usage{
ZoonModel(model, code, packages)
}
\arguments{
\item{model}{a fitted model object to be used for making predictions}

\item{code}{code to make predictions from \code{model} object to
a dataframe \code{newdata} containing new covariate observations.
The code must use the objects named \code{model} and \code{newdata} and
no other objects and must return a numeric vector, with the same length
as the number of rows in \code{newdata} giving predictions on the response
scale (e.g. probabilities of presence).}

\item{packages}{a character vector giving the names of packages
needed to run the code zoonModel a \code{zoonModel} object}
}
\value{
an object of class \code{zoonModel} containing all of the
 information and code required to make predictions, using the function
 \code{\link{ZoonPredict}}
}
\description{
\strong{module developer tool:} Create a Zoon model object
}
\details{
\strong{This function is only intended to be used when developing
new modules, not for running zoon workflows}.
Given a \code{zoonModel} object returned by a model
module using the function \code{ZoonModel}, make a prediction to
a new dataframe.
For an example, see the source code for the module \code{InteractiveMap}.
}
