% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zipr.R
\name{zipr}
\alias{zipr}
\title{zip two vector-like objects into a dataframe}
\usage{
zipr(x = x, y = x, broadcast = FALSE, fill = FALSE,
  fillvalue = c(NA))
}
\arguments{
\item{x}{vector-like object}

\item{y}{vector-like object}

\item{broadcast}{defaults to FALSE; if TRUE, shorter sequence is repeated until its length is equal to that of the longer sequence}

\item{fill}{defaults to FALSE; bool for whether fillvalue should be implemented}

\item{fillvalue}{value or sequence of value(s) to fill in shorter sequence until it is the same length as the longer sequence. Defaults to NA}
}
\value{
A dataframe
}
\description{
zip two vector-like objects into a dataframe
}
\examples{

a <- c(1,2,3)
b <- c(4,5,6)
c <- c(1,2,3,4,5,6)
d <- c(7,8)
z <- c(9)
filler <- c(NA)

# zip two vectors of the same length
zipr(a,b)

# zip two vectors of different lengths, repeating the shorter vector
zipr(a, z, broadcast = TRUE)

# zip two vectors of different lengths, using the default fill value
zipr(z, a, fill = TRUE)

# zip two vectors of different lengths, using a custom fill value
zipr(c,a, fill = TRUE, fillvalue = z)
}
