% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{burst_aux}
\alias{burst_aux}
\title{Auxiliary function for burst()}
\usage{
burst_aux(x, labs = "V")
}
\arguments{
\item{x}{A vector, matrix or data.frame (or a (pure) list, but that we don't use here)}

\item{labs}{The variable labels:
- if NULL, no labels are used
- if of length 1, use this label and append 1:ncol(x)
  but only if x doesn't have any column names (otherwise use the latter)
- if of length ncol(x), use that
  but only if x doesn't have any column names (otherwise use the latter)}
}
\value{
'x' as a list of named columns
}
\description{
Auxiliary function for burst()
}
\note{
- Performance critical (no checks here)
      - Data frames always have default names. They are possibly
        ugly but we have to use them here as we cannot
        determine whether they were assigned automatically or
        on purpose.
}
\seealso{
Other tools for constructing your own plot1d and plot2d functions: 
\code{\link{burst}()},
\code{\link{check_zargs}()},
\code{\link{extract_1d}()},
\code{\link{extract_2d}()},
\code{\link{plot_indices}()}
}
\author{
Marius Hofert
}
\concept{tools for constructing your own plot1d and plot2d functions}
