% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{burst}
\alias{burst}
\title{Splitting an Input Object into a List of Columns}
\usage{
burst(x, labs = list())
}
\arguments{
\item{x}{A \code{\link{numeric}} \code{\link{vector}}, \code{\link{matrix}},
\code{\link{data.frame}} or, for \code{burst()}, a \code{\link{list}} of such.}

\item{labs}{Either \code{\link{NULL}} 
(in which case neither group nor variable labels are used or computed) or 
a list with components

       \code{group} - the group label basename or labels for the groups 
                     (or \code{\link{NULL}} for no group labels)
       
       \code{var} - the variable label basename or labels for the variables 
       (or \code{\link{NULL}} for no variable labels)
       
       \code{sep} - the string used as the separator between group and 
       variable labels
       
       \code{group2d} - a \code{\link{logical}} indicating whether labels of 
       \code{group_2d_*()} plots are affected by \code{group = NULL} (or printed anyway)
           
If any of these components is not given, it is set to the defaults as described in
\code{\link{zenplot}()}. 
Note that if at least one (group or variable) label is given in \code{x}, 
then those (original) labels will be used.       
If labs = NULL, neither group nor variable labels are used.}
}
\value{
A \code{\link{list}} with components

         \code{xcols} - a list containing the column vectors of  \code{x}
         
         \code{groups} - the group number for each column of  \code{x}
         
         \code{vars} - the variable number (within each group) for each column of  \code{x}
         
         \code{glabs} - the group label for each column of  \code{x}
         
         \code{labs} - the group and variable labels for each column of  \code{x}
}
\description{
Splits a (numeric/logical/character) vector, matrix, 
data.frame or a list of such into a list of columns, with corresponding 
group and variable information as well as labels.  
This is an auxiliary function for checking and converting the data argument of zenplot().
}
\note{
Performance critical
}
\examples{
## Unnamed list of (some named, some unnamed) valid components
A <- matrix(1:12, ncol = 3)
x <- list(A, 1:4, as.data.frame(A))

burst(x, labs = list(group = "G", var = "V", sep = ", "))
burst(x) # the same defaults as above
burst(x, labs = list(sep = " ")) # only changing the separator
## Note: - No group labels are given in 'x' and thus they are constructed
##         in the above call
##        - The variable names are only constructed if not given

burst(x, labs = list(group = ""))
burst(x, labs = list(group = NULL, group2d = TRUE)) # no group labels
##  Note: There's no effect of 'group2d = TRUE' visible here as
##        'x' doesn't contain group labels

burst(x, labs = list(group = NULL)) # no group labels unless groups change
burst(x, labs = list(var = NULL)) # no variable labels
burst(x, labs = list(group = NULL, var = NULL)) # neither one
burst(x, labs = NULL) # similarly, without any labels at all

##  Named list
x <- list(mat = A, vec = 1:4, df = as.data.frame(A))
burst(x)
##  Note: - The given group labels are used
##        - The variable names are only constructed if not given

burst(x, labs = list(group = NULL, group2d = TRUE)) # no group labels
burst(x, labs = list(group = NULL)) # no group labels unless groups change
##  Note: Now the effect of 'group2d' is visible.

##  Partially named list
x <- list(mat = A, vec = 1:4, as.data.frame(A))
burst(x)
burst(x, labs = list(group = NULL, group2d = TRUE)) # no group labels
burst(x, labs = list(group = NULL)) # no group labels unless groups change
burst(x, labs = list(var = NULL)) # no variable labels
burst(x, labs = list(group = NULL, var = NULL)) # only group labels and only if groups change
burst(x, labs = NULL) # neither group nor variable labels
}
\seealso{
Other tools for constructing your own plot1d and plot2d functions: 
\code{\link{burst_aux}()},
\code{\link{check_zargs}()},
\code{\link{extract_1d}()},
\code{\link{extract_2d}()},
\code{\link{plot_indices}()}
}
\author{
Marius Hofert
}
\concept{tools for constructing your own plot1d and plot2d functions}
\keyword{datagen}
