% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{summary.zcurve}
\alias{summary.zcurve}
\title{Summarize fitted z-curve object}
\usage{
\method{summary}{zcurve}(
  object,
  type = "results",
  all = FALSE,
  ERR.adj = 0.03,
  EDR.adj = 0.05,
  round.coef = 3,
  ...
)
}
\arguments{
\item{object}{A fitted z-curve object.}

\item{type}{Whether the results \code{"results"} or the
mixture mode parameters \code{"parameters"} should be
returned. Defaults to  \code{"results"}.}

\item{all}{Whether additional results, such as file drawer
ration, expected and missing number of studies, and Soric FDR
be returned. Defaults to \code{FALSE}}

\item{ERR.adj}{Confidence intervals adjustment for ERR. Defaults
to \code{.03} as proposed by Bartos & Schimmack (in preparation).}

\item{EDR.adj}{Confidence intervals adjustment for EDR. Defaults
to \code{.05} as proposed by Bartos & Schimmack (in preparation).}

\item{round.coef}{To how many decimals should the coefficient
be rounded. Defaults to \code{3}.}

\item{...}{Additional arguments}
}
\value{
Summary of a z-curve object
}
\description{
Summarize fitted z-curve object
}
\seealso{
\code{\link[=zcurve]{zcurve()}}
}
