% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zVarArrayTest.R
\name{zVarArrayTest}
\alias{zVarArrayTest}
\title{Variation array homogeneity test}
\usage{
zVarArrayTest(X, label = 0, groups = NULL, b = 1000)
}
\arguments{
\item{X}{Compositional data set (\code{\link{matrix}} or \code{\link{data.frame}} class).}

\item{label}{Unique label (\code{\link{numeric}} or \code{\link{character}}) used to denote zero or unobserved data in \code{X} (\code{label = 0}, default).}

\item{groups}{Grouping factor in fully observed zero-free data sets (\code{groups = NULL}, default).}

\item{b}{Number of bootstrap resamples used (\code{b = 1000}, default).}
}
\value{
Test p-values for log-ratio variances and means.
}
\description{
This function performs a permutation test of the homogeneity of group-wise and overall variation arrays from all
pair-wise log-ratios in a compositional data set. Groups can be defined by either zero/unobserved data patterns or by a grouping
factor in fully observed zero-free data sets.
}
\details{
The permutation test of homogeneity is based on total weighted squared relative errors (SRE) reflecting on divergence
between group-wise variation arrays and overall (see \code{\link{zVarArrayError}} and
\code{\link{zVarArray}} for more details). Note that for groups including less than two observations SRE is set to NA.
}
\examples{
data(Water)
zPatterns(Water, label = 0)
zVarArrayTest(Water)
}
\seealso{
\code{\link{zPatterns}}, \code{\link{zVarArray}}, \code{\link{zVarArrayError}}
}

