% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yml_params.R
\name{yml_params}
\alias{yml_params}
\alias{shiny_params}
\alias{shiny_checkbox}
\alias{shiny_numeric}
\alias{shiny_slider}
\alias{shiny_date}
\alias{shiny_text}
\alias{shiny_file}
\alias{shiny_radio}
\alias{shiny_select}
\alias{shiny_password}
\title{Parameterize an R Markdown report using Shiny components}
\usage{
yml_params(.yml, ...)

shiny_params(.shiny)

shiny_checkbox(label, value = FALSE, width = NULL)

shiny_numeric(label, value, min = NA, max = NA, step = NA,
  width = NULL)

shiny_slider(label, min, max, value, step = NULL, round = FALSE,
  format = NULL, locale = NULL, ticks = TRUE, animate = FALSE,
  width = NULL, sep = ",", pre = NULL, post = NULL,
  timeFormat = NULL, timezone = NULL, dragRange = TRUE)

shiny_date(label, value = NULL, min = NULL, max = NULL,
  format = "yyyy-mm-dd", startview = "month", weekstart = 0,
  language = "en", width = NULL, autoclose = TRUE,
  datesdisabled = NULL, daysofweekdisabled = NULL)

shiny_text(label, value = "", width = NULL, placeholder = NULL)

shiny_file(label, multiple = FALSE, accept = NULL, width = NULL,
  buttonLabel = "Browse...", placeholder = "No file selected")

shiny_radio(label, choices = NULL, selected = NULL, inline = FALSE,
  width = NULL, choiceNames = NULL, choiceValues = NULL)

shiny_select(label, choices, selected = NULL, multiple = FALSE,
  selectize = TRUE, width = NULL, size = NULL)

shiny_password(label, value = "", width = NULL, placeholder = NULL)
}
\arguments{
\item{.yml}{a \code{yml} object created by \code{yml()}, \code{as_yml()}, or returned by
a \code{yml_*()} function}

\item{...}{additional named R objects, such as characters or lists, to
transform into YAML}

\item{.shiny}{a Shiny function call to capture and convert to YAML}

\item{label}{Display label for the control, or \code{NULL} for no label.}

\item{value}{Initial value (\code{TRUE} or \code{FALSE}).}

\item{width}{The width of the input, e.g. '400px', or '100%'; see
\code{\link[shiny:validateCssUnit]{shiny::validateCssUnit()}}}

\item{min}{Minimum allowed value}

\item{max}{Maximum allowed value}

\item{step}{Interval to use when stepping between min and max}

\item{round}{\code{TRUE} to round all values to the nearest integer;
\code{FALSE} if no rounding is desired; or an integer to round to that
number of digits (for example, 1 will round to the nearest 10, and -2 will
round to the nearest .01). Any rounding will be applied after snapping to
the nearest step.}

\item{format}{Deprecated.}

\item{locale}{Deprecated.}

\item{ticks}{\code{FALSE} to hide tick marks, \code{TRUE} to show them
according to some simple heuristics.}

\item{animate}{\code{TRUE} to show simple animation controls with default
settings; \code{FALSE} not to; or a custom settings list, such as those created
using \code{\link[shiny:animationOptions]{shiny::animationOptions()}}}

\item{sep}{Separator between thousands places in numbers.}

\item{pre}{A prefix string to put in front of the value.}

\item{post}{A suffix string to put after the value.}

\item{timeFormat}{Only used if the values are Date or POSIXt objects. A time
format string, to be passed to the Javascript strftime library. See
\url{https://github.com/samsonjs/strftime} for more details. The allowed
format specifications are very similar, but not identical, to those for R's
\code{\link[base]{strftime}} function. For Dates, the default is \code{"\%F"}
(like \code{"2015-07-01"}), and for POSIXt, the default is \code{"\%F \%T"}
(like \code{"2015-07-01 15:32:10"}).}

\item{timezone}{Only used if the values are POSIXt objects. A string
specifying the time zone offset for the displayed times, in the format
\code{"+HHMM"} or \code{"-HHMM"}. If \code{NULL} (the default), times will
be displayed in the browser's time zone. The value \code{"+0000"} will
result in UTC time.}

\item{dragRange}{This option is used only if it is a range slider (with two
values). If \code{TRUE} (the default), the range can be dragged. In other
words, the min and max can be dragged together. If \code{FALSE}, the range
cannot be dragged.}

\item{startview}{The date range shown when the input object is first clicked.
Can be "month" (the default), "year", or "decade".}

\item{weekstart}{Which day is the start of the week. Should be an integer
from 0 (Sunday) to 6 (Saturday).}

\item{language}{The language used for month and day names. Default is "en".
Other valid values include "ar", "az", "bg", "bs", "ca", "cs", "cy", "da",
"de", "el", "en-AU", "en-GB", "eo", "es", "et", "eu", "fa", "fi", "fo",
"fr-CH", "fr", "gl", "he", "hr", "hu", "hy", "id", "is", "it-CH", "it",
"ja", "ka", "kh", "kk", "ko", "kr", "lt", "lv", "me", "mk", "mn", "ms",
"nb", "nl-BE", "nl", "no", "pl", "pt-BR", "pt", "ro", "rs-latin", "rs",
"ru", "sk", "sl", "sq", "sr-latin", "sr", "sv", "sw", "th", "tr", "uk",
"vi", "zh-CN", and "zh-TW".}

\item{autoclose}{Whether or not to close the datepicker immediately when a
date is selected.}

\item{datesdisabled}{Which dates should be disabled. Either a Date object,
or a string in \code{yyyy-mm-dd} format.}

\item{daysofweekdisabled}{Days of the week that should be disabled. Should be
a integer vector with values from 0 (Sunday) to 6 (Saturday).}

\item{placeholder}{A character string giving the user a hint as to what can
be entered into the control. Internet Explorer 8 and 9 do not support this
option.}

\item{multiple}{Whether the user should be allowed to select and upload
multiple files at once. \bold{Does not work on older browsers, including
Internet Explorer 9 and earlier.}}

\item{accept}{A character vector of MIME types; gives the browser a hint of
what kind of files the server is expecting.}

\item{buttonLabel}{The label used on the button. Can be text or an HTML tag
object.}

\item{choices}{List of values to select from (if elements of the list are
named then that name rather than the value is displayed to the user). If
this argument is provided, then \code{choiceNames} and \code{choiceValues}
must not be provided, and vice-versa. The values should be strings; other
types (such as logicals and numbers) will be coerced to strings.}

\item{selected}{The initially selected value (if not specified then defaults
to the first value)}

\item{inline}{If \code{TRUE}, render the choices inline (i.e. horizontally)}

\item{choiceNames}{List of names and values, respectively, that
are displayed to the user in the app and correspond to the each choice (for
this reason, \code{choiceNames} and \code{choiceValues} must have the same
length). If either of these arguments is provided, then the other
\emph{must} be provided and \code{choices} \emph{must not} be provided. The
advantage of using both of these over a named list for \code{choices} is
that \code{choiceNames} allows any type of UI object to be passed through
(tag objects, icons, HTML code, ...), instead of just simple text. See
Examples.}

\item{choiceValues}{List of names and values, respectively, that
are displayed to the user in the app and correspond to the each choice (for
this reason, \code{choiceNames} and \code{choiceValues} must have the same
length). If either of these arguments is provided, then the other
\emph{must} be provided and \code{choices} \emph{must not} be provided. The
advantage of using both of these over a named list for \code{choices} is
that \code{choiceNames} allows any type of UI object to be passed through
(tag objects, icons, HTML code, ...), instead of just simple text. See
Examples.}

\item{selectize}{Whether to use \pkg{selectize.js} or not.}

\item{size}{Number of items to show in the selection box; a larger number
will result in a taller box. Not compatible with \code{selectize=TRUE}.
Normally, when \code{multiple=FALSE}, a select input will be a drop-down
list, but when \code{size} is set, it will be a box instead.}
}
\value{
a \code{yml} object
}
\description{
R Markdown lets you add dynamic parameters to your report using the \code{params}
YAML field (see the \href{https://bookdown.org/yihui/rmarkdown/parameterized-reports.html}{R Markdown book} for
examples); parameterized reports are also used in RStudio Connect. The values
of these variables can be called inside your R Markdown document using
\code{params$field_name}. \href{https://bookdown.org/yihui/rmarkdown/params-knit.html}{There are several ways to change the values of the parameters}: manually
change the YAML, use the \code{params} argument in \code{rmarkdown::render()}, or knit
with parameters, which launches a Shiny app to select values for each.
\code{yml_params()} accepts any number of named R objects to set as YAML fields.
You can also pass arguments to the underlying Shiny functions using YAML. To
set a shiny component, use the \code{shiny_*()} helper functions. \code{shiny_params()}
captures a Shiny output function and transforms it to YAML. However, R
Markdown supports only a limited number of components; each of these is
included as a function starting with \code{shiny_*()}, e.g. \code{shiny_checkbox()}
}
\examples{

yml() \%>\%
  yml_params(
    z = "z",
    x = shiny_numeric("Starting value", 23),
    no = shiny_checkbox("No option?"),
    y = shiny_slider("Data range", 0, 1, .5, round = TRUE)
  )

}
\seealso{
\code{\link[=yml_params_code]{yml_params_code()}}

Other yml: \code{\link{asis_yaml_output}},
  \code{\link{bib2yml}}, \code{\link{draw_yml_tree}},
  \code{\link{has_field}}, \code{\link{read_json}},
  \code{\link{use_yml_defaults}},
  \code{\link{use_yml_file}}, \code{\link{use_yml}},
  \code{\link{yml_author}},
  \code{\link{yml_blogdown_opts}},
  \code{\link{yml_bookdown_opts}},
  \code{\link{yml_citations}}, \code{\link{yml_clean}},
  \code{\link{yml_distill_opts}},
  \code{\link{yml_latex_opts}}, \code{\link{yml_output}},
  \code{\link{yml_pagedown_opts}},
  \code{\link{yml_pkgdown}}, \code{\link{yml_reference}},
  \code{\link{yml_replace}},
  \code{\link{yml_resource_files}},
  \code{\link{yml_rsconnect_email}},
  \code{\link{yml_rticles_opts}},
  \code{\link{yml_runtime}}, \code{\link{yml_site_opts}},
  \code{\link{yml_toc}}, \code{\link{yml_vignette}}

Other R Markdown: \code{\link{yml_clean}},
  \code{\link{yml_runtime}}, \code{\link{yml_site_opts}},
  \code{\link{yml_vignette}}

Other shiny: \code{\link{yml_runtime}}
}
\concept{R Markdown}
\concept{shiny}
\concept{yml}
