% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yf_data_convert_to_wide.R
\name{yf_convert_to_wide}
\alias{yf_convert_to_wide}
\title{Transforms a long (stacked) data frame into a list of wide data frames}
\usage{
yf_convert_to_wide(df_in)
}
\arguments{
\item{df_in}{dataframe in the long format (probably the output of yf_get())}
}
\value{
A list with dataframes in the wide format (each element is a
  different column)
}
\description{
Transforms a long (stacked) data frame into a list of wide data frames
}
\examples{

my_f <- system.file("extdata/example_data_yfR.rds", package = "yfR")
df_tickers <- readRDS(my_f)

print(df_tickers)

l_wide <- yf_convert_to_wide(df_tickers)
l_wide
}
