% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/num-mase.R
\name{mase}
\alias{mase}
\alias{mase.data.frame}
\alias{mase_vec}
\title{Mean absolute scaled error}
\usage{
mase(data, ...)

\method{mase}{data.frame}(
  data,
  truth,
  estimate,
  m = 1L,
  mae_train = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  ...
)

mase_vec(
  truth,
  estimate,
  m = 1L,
  mae_train = NULL,
  na_rm = TRUE,
  case_weights = NULL,
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by the \code{truth}
and \code{estimate} arguments.}

\item{...}{Not currently used.}

\item{truth}{The column identifier for the true results
(that is \code{numeric}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{numeric} vector.}

\item{estimate}{The column identifier for the predicted
results (that is also \code{numeric}). As with \code{truth} this can be
specified different ways but the primary method is to use an
unquoted variable name. For \verb{_vec()} functions, a \code{numeric} vector.}

\item{m}{An integer value of the number of lags used to calculate the
in-sample seasonal naive error. The default is used for non-seasonal time
series. If each observation was at the daily level and the data showed weekly
seasonality, then \code{m = 7L} would be a reasonable choice for a 7-day seasonal
naive calculation.}

\item{mae_train}{A numeric value which allows the user to provide the
in-sample seasonal naive mean absolute error. If this value is not provided,
then the out-of-sample seasonal naive mean absolute error will be calculated
from \code{truth} and will be used instead.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights. This
should be an unquoted column name that evaluates to a numeric column in
\code{data}. For \verb{_vec()} functions, a numeric vector,
\code{\link[hardhat:importance_weights]{hardhat::importance_weights()}}, or \code{\link[hardhat:frequency_weights]{hardhat::frequency_weights()}}.}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{mase_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
Calculate the mean absolute scaled error. This metric is \emph{scale independent}
and \emph{symmetric}. It is generally used for comparing forecast error in
time series settings. Due to the time series nature of this metric, it
is necessary to order observations in ascending order by time.
}
\details{
\code{mase()} is different from most numeric metrics. The original implementation
of \code{mase()} calls for using the \emph{in-sample} naive mean absolute error to
compute scaled errors with. It uses this instead of the out-of-sample error
because there is a chance that the out-of-sample error cannot be computed
when forecasting a very short horizon (i.e. the out of sample size is only
1 or 2). However, \code{yardstick} only knows about the out-of-sample \code{truth} and
\code{estimate} values. Because of this, the out-of-sample error is used in the
computation by default. If the in-sample naive mean absolute error is
required and known, it can be passed through in the \code{mae_train} argument
and it will be used instead. If the in-sample data is available, the
naive mean absolute error can easily be computed with
\code{mae(data, truth, lagged_truth)}.
}
\examples{
# Supply truth and predictions as bare column names
mase(solubility_test, solubility, prediction)

library(dplyr)

set.seed(1234)
size <- 100
times <- 10

# create 10 resamples
solubility_resampled <- bind_rows(
  replicate(
    n = times,
    expr = sample_n(solubility_test, size, replace = TRUE),
    simplify = FALSE
  ),
  .id = "resample"
)

# Compute the metric by group
metric_results <- solubility_resampled \%>\%
  group_by(resample) \%>\%
  mase(solubility, prediction)

metric_results

# Resampled mean estimate
metric_results \%>\%
  summarise(avg_estimate = mean(.estimate))
}
\references{
Rob J. Hyndman (2006). ANOTHER LOOK AT FORECAST-ACCURACY METRICS FOR
INTERMITTENT DEMAND. \emph{Foresight}, 4, 46.
}
\seealso{
Other numeric metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{rpd}()},
\code{\link{rpiq}()},
\code{\link{rsq_trad}()},
\code{\link{rsq}()},
\code{\link{smape}()}

Other accuracy metrics: 
\code{\link{ccc}()},
\code{\link{huber_loss_pseudo}()},
\code{\link{huber_loss}()},
\code{\link{iic}()},
\code{\link{mae}()},
\code{\link{mape}()},
\code{\link{mpe}()},
\code{\link{msd}()},
\code{\link{poisson_log_loss}()},
\code{\link{rmse}()},
\code{\link{smape}()}
}
\author{
Alex Hallam
}
\concept{accuracy metrics}
\concept{numeric metrics}
