% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prob-roc_aunu.R
\name{roc_aunu}
\alias{roc_aunu}
\alias{roc_aunu.data.frame}
\alias{roc_aunu_vec}
\title{Area under the ROC curve of each class against the rest, using the uniform
class distribution}
\usage{
roc_aunu(data, ...)

\method{roc_aunu}{data.frame}(data, truth, ..., na_rm = TRUE, case_weights = NULL, options = list())

roc_aunu_vec(
  truth,
  estimate,
  na_rm = TRUE,
  case_weights = NULL,
  options = list(),
  ...
)
}
\arguments{
\item{data}{A \code{data.frame} containing the columns specified by \code{truth} and
\code{...}.}

\item{...}{A set of unquoted column names or one or more \code{dplyr} selector
functions to choose which variables contain the class probabilities. There
should be as many columns as factor levels of \code{truth}.}

\item{truth}{The column identifier for the true class results
(that is a \code{factor}). This should be an unquoted column name although
this argument is passed by expression and supports
\link[rlang:topic-inject]{quasiquotation} (you can unquote column
names). For \verb{_vec()} functions, a \code{factor} vector.}

\item{na_rm}{A \code{logical} value indicating whether \code{NA}
values should be stripped before the computation proceeds.}

\item{case_weights}{The optional column identifier for case weights.
This should be an unquoted column name that evaluates to a numeric column
in \code{data}. For \verb{_vec()} functions, a numeric vector.}

\item{options}{\verb{[deprecated]}

No longer supported as of yardstick 1.0.0. If you pass something here it
will be ignored with a warning.

Previously, these were options passed on to \code{pROC::roc()}. If you need
support for this, use the pROC package directly.}

\item{estimate}{A matrix with as many
columns as factor levels of \code{truth}. \emph{It is assumed that these are in the
same order as the levels of \code{truth}.}}
}
\value{
A \code{tibble} with columns \code{.metric}, \code{.estimator},
and \code{.estimate} and 1 row of values.

For grouped data frames, the number of rows returned will be the same as
the number of groups.

For \code{roc_aunu_vec()}, a single \code{numeric} value (or \code{NA}).
}
\description{
\code{roc_aunu()} is a multiclass metric that computes the area under the ROC
curve of each class against the rest, using the uniform class distribution.
This is equivalent to \code{roc_auc(estimator = "macro")}.
}
\section{Relevant Level}{


There is no common convention on which factor level should
automatically be considered the "event" or "positive" result
when computing binary classification metrics. In \code{yardstick}, the default
is to use the \emph{first} level. To alter this, change the argument
\code{event_level} to \code{"second"} to consider the \emph{last} level of the factor the
level of interest. For multiclass extensions involving one-vs-all
comparisons (such as macro averaging), this option is ignored and
the "one" level is always the relevant result.
}

\section{Multiclass}{

This multiclass method for computing the area under the ROC curve uses the
uniform class distribution and is equivalent to
\code{roc_auc(estimator = "macro")}.
}

\examples{
# Multiclass example

# `obs` is a 4 level factor. The first level is `"VF"`, which is the
# "event of interest" by default in yardstick. See the Relevant Level
# section above.
data(hpc_cv)

# You can use the col1:colN tidyselect syntax
library(dplyr)
hpc_cv \%>\%
  filter(Resample == "Fold01") \%>\%
  roc_aunu(obs, VF:L)

# Change the first level of `obs` from `"VF"` to `"M"` to alter the
# event of interest. The class probability columns should be supplied
# in the same order as the levels.
hpc_cv \%>\%
 filter(Resample == "Fold01") \%>\%
  mutate(obs = relevel(obs, "M")) \%>\%
  roc_aunu(obs, M, VF:L)

# Groups are respected
hpc_cv \%>\%
  group_by(Resample) \%>\%
  roc_aunu(obs, VF:L)

# Vector version
# Supply a matrix of class probabilities
fold1 <- hpc_cv \%>\%
  filter(Resample == "Fold01")

roc_aunu_vec(
  truth = fold1$obs,
  matrix(
    c(fold1$VF, fold1$F, fold1$M, fold1$L),
    ncol = 4
  )
)
}
\references{
Ferri, C., Hernández-Orallo, J., & Modroiu, R. (2009). "An experimental
comparison of performance measures for classification". \emph{Pattern Recognition
Letters}. 30 (1), pp 27-38.
}
\seealso{
\code{\link[=roc_aunp]{roc_aunp()}} for computing the area under the ROC curve of each class against
the rest, using the a priori class distribution.

Other class probability metrics: 
\code{\link{average_precision}()},
\code{\link{classification_cost}()},
\code{\link{gain_capture}()},
\code{\link{mn_log_loss}()},
\code{\link{pr_auc}()},
\code{\link{roc_auc}()},
\code{\link{roc_aunp}()}
}
\author{
Julia Silge
}
\concept{class probability metrics}
