% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xtable.R
\name{footnote.decorated}
\alias{footnote.decorated}
\title{Footnote Decorated}
\usage{
\method{footnote}{decorated}(x, ..., equal = ":", collapse = "; ")
}
\arguments{
\item{x}{decorated}

\item{...}{passed to \code{\link{append_units}}}

\item{equal}{character: a symbol suggesting equality between a name and its note}

\item{collapse}{used to \code{\link{paste}} column-wise footnotes}
}
\value{
character
}
\description{
Footnotes a decorated data.frame.
Generates a text string that defines
column names using label and unit attributes.
}
\examples{
library(magrittr)
set.seed(0)
x <- data.frame(
 auc = rnorm(100, mean = 2400, sd = 200),
 bmi = rnorm(100, mean = 20, sd = 5),
 gen = 0:1
)
x \%<>\% decorate('auc: [AUC_0-24, ng*h/mL]')
x \%<>\% decorate('bmi: [Body Mass Index, kg/m^2]')
x \%<>\% decorate('gen: [Gender, [Male: 1, Female: 0]]')
x \%<>\% resolve
footnote(x)
footnote(x, auc)
}
\seealso{
Other footnote: 
\code{\link{footnote}()}
}
\concept{footnote}
\keyword{internal}
