% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{decorate.data.frame}
\alias{decorate.data.frame}
\title{Decorate Data Frame}
\usage{
\method{decorate}{data.frame}(x, meta = NULL,
  coerce = getOption("coerce", FALSE), ...)
}
\arguments{
\item{x}{data.frame}

\item{meta}{file path for corresponding yaml metadata, or a yamlet; an attempt will be made to guess the file path if x has a 'source' attribute}

\item{coerce}{whether to coerce to factor where guide is a list}

\item{...}{passed arguments}
}
\value{
data.frame
}
\description{
Decorates a data.frame. Expects metadata with labels and guides,
where guides are units, factor levels and labels (codes, decodes), or
datetime formatting strings. For guides that are lists, the corresponding
data element may optionally be coerced to factor.
}
\examples{
library(csv)
file <- system.file(package = 'yamlet', 'extdata','yamlet.csv')
meta <- system.file(package = 'yamlet', 'extdata','yamlet.yaml')
x <- decorate(as.csv(file))
x <- decorate(as.csv(file))
x <- decorate(as.csv(file), meta = as_yamlet(meta))
x <- decorate(as.csv(file), meta = meta)
x <- decorate(as.csv(file), meta = file)
x <- decorate(as.csv(file), coerce = TRUE)
sapply(x, attr, 'label')

}
\seealso{
Other decorate: \code{\link{decorate.character}},
  \code{\link{decorate.list}}, \code{\link{decorate}},
  \code{\link{decorations.data.frame}},
  \code{\link{decorations}}
}
\concept{decorate}
