% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/yamlet.R
\name{as_yam.yamlet}
\alias{as_yam.yamlet}
\title{Coerce Yamlet to Yam}
\usage{
\method{as_yam}{yamlet}(x, default_keys = list("label", "guide"), ...)
}
\arguments{
\item{x}{yamlet}

\item{default_keys}{names that may be omitted in left subsets}

\item{...}{passed arguments}
}
\value{
yam
}
\description{
Coerces class yamlet to yam, negotiating the default keys.
For each member of x, names of sub-members will be dropped
if all previous such have been dropped.  I.e., attribute
order is preserved, and 'guide' (by default) will not be
made implicit unless 'label' has already been encountered
(and made implicit).  Default keys are attached as the 'keys'
attribute of the result.
}
\examples{
as_yam(as_yamlet(c('id: subject','amt: dose')))
as_yam(as_yamlet(c('amt: [ dose, mg ]')))
as_yam(as_yamlet(c('amt: [ guide: mg, label: dose ]')))

}
\seealso{
Other yam: \code{\link{as.character.yam}},
  \code{\link{as_yam.character}}, \code{\link{as_yam}}
}
\concept{yam}
