% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/unclassified.R
\name{unclassified.data.frame}
\alias{unclassified.data.frame}
\title{Unclassify Data Frame}
\usage{
\method{unclassified}{data.frame}(x, ...)
}
\arguments{
\item{x}{data.frame}

\item{...}{passed to \code{\link[dplyr]{select}} to limit scope}
}
\value{
data.frame
}
\description{
Unclassifies data.frame.
Coerces 'classified' items to original values,
rebuilding codelist attribute.
}
\examples{
library(magrittr)
file <- system.file(package = 'yamlet', 'extdata','quinidine.csv')
x <- decorate(file)
x \%>\% explicit_guide \%>\% decorations(Age, Race, Heart:glyco)
x \%>\% explicit_guide \%>\% classified \%>\% unclassified \%>\% decorations(Age, Race, Heart:glyco)
}
\seealso{
Other classified: 
\code{\link{[.classified}()},
\code{\link{[<-.classified}()},
\code{\link{[[.classified}()},
\code{\link{[[<-.classified}()},
\code{\link{as.integer.classified}()},
\code{\link{c.classified}()},
\code{\link{classified.classified}()},
\code{\link{classified.data.frame}()},
\code{\link{classified.default}()},
\code{\link{classified.dvec}()},
\code{\link{classified.factor}()},
\code{\link{classified_generic}},
\code{\link{desolve.classified}()},
\code{\link{unclassified.classified}()},
\code{\link{unclassified}()}
}
\concept{classified}
\keyword{internal}
