% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/grnn.predict.R
\name{grnn.predict}
\alias{grnn.predict}
\title{Calculate predicted values of GRNN}
\usage{
grnn.predict(net, x)
}
\arguments{
\item{net}{The GRNN object generated by grnn.fit()}

\item{x}{The matrix of input predictors}
}
\value{
A vector of predicted values
}
\description{
The function \code{grnn.predict} calculates a vector of GRNN predicted values based on an input matrix
}
\examples{
data(iris, package = "datasets")
Y <- ifelse(iris[, 5] == "setosa", 1, 0)
X <- scale(iris[, 1:4])
gnet <- grnn.fit(x = X, y = Y)
grnn.predict(gnet, X[seq(5), ])
}
\seealso{
\code{\link{grnn.predone}}
}
