% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/module1_commons.R
\name{irt.model}
\alias{irt.model}
\alias{irt.model.3pl.init}
\alias{irt.rescale.3pl}
\alias{irt.sample}
\alias{irt.select}
\alias{irt.stats}
\alias{plot.irt.model}
\alias{print.irt.model}
\title{Common IRT Computations and Operations}
\usage{
irt.model(people = NULL, items = NULL, responses = NULL, model = "3pl")

irt.model.3pl.init(theta, a, b, c, responses = NULL)

irt.stats(x, stats = "probability", summary = NULL, fun = NULL, ...)

\method{print}{irt.model}(x, ...)

\method{plot}{irt.model}(x, ...)

irt.select(x, people.index = NULL, items.index = NULL)

irt.sample(x, n.people = 0, n.items = 0)

irt.rescale.3pl(x, parameter = "theta", mu = 0, sig = 1)
}
\arguments{
\item{people}{a data frame of people parameters}

\item{items}{a data frame of item parameters}

\item{responses}{a data frame of responses}

\item{model}{the name of IRT model}

\item{theta}{a vector of theta parameters}

\item{a}{a vector of a parameters}

\item{b}{a vector of b parameters}

\item{c}{a vector of b parameters}

\item{x}{a \code{irt.model} object}

\item{stats}{the statistic to be computed (e.g., \code{probability}, \code{information}, \code{likelihood})}

\item{summary}{the summarization dimension (e.g., \code{people}, \code{items})}

\item{fun}{the summarization function (e.g, \code{sum} or \code{prod})}

\item{...}{other optional arguments}

\item{people.index}{the indices of people to select}

\item{items.index}{the indices of items to select}

\item{n.people}{the nubmer of people to sample}

\item{n.items}{the number of items to sample}

\item{parameter}{the rescaling parameter}

\item{mu}{the mean of the new scale}

\item{sig}{the standard deviation of the new scale}
}
\value{
\code{irt.model} returns a \code{irt.mode} object

\code{irt.stats} returns a vector/matrix of resulting computation values

\code{plot.irt.model} returns a 'ggplot2' object
}
\description{
\code{irt.model} is a function for creating \code{irt.model} objects

\code{irt.model.3pl.init} is a function for creating \code{irt.model.3pl} object using parameter vectors

\code{irt.stats} is a function for common IRT computations (e.g., probability, information, likelihood)

\code{plot.irt.model} draws the item/test characteristics curve, informaiton function, likelihood curve for an IRT object

\code{irt.select} selects data from an IRT object

\code{irt.sample} samples data from an IRT object

\code{irt.rescale.3pl} rescale 3PL parameters
}
\details{
A \code{irt.model} object contains people parameters, item parameters and responses.
The \code{irt.model} also contains functions to\code{probability}, \code{informaiton} and \code{likelihood}.
In addtional, it has a \code{gen.data} function to generate data. \cr

In \code{plot.irt.model}, use the \code{stats} argument to control what IRT statistics for drawing.
Use \code{total} argument to control draw one summed line for the whole test or multiple line for indiviual items.
When drawing \code{stats="loglikelihood"}, make sure the \code{irt.model} object has only one person

\code{irt.select} subsets responses when it is not \code{NULL}.
When \code{people.index} or \code{items.index} is \code{NULL}, keep all.
}
\examples{
# create a 3PL model with manual inputs
people <- data.frame(theta=c(-1,0,1))
items <- data.frame(a=c(.5,1,1.5,1,1,1,1), b=c(0,0,0,-1,1,0,0), c=c(0,0,0,0,0,.1,.2))
responses <- data.frame(item1=c(0,0,1), item2=c(0,1,1), item3=c(0,1,1), 
item4=c(1,1,1), item5=c(0,0,1), item6=c(0,1,1), item7=c(1,1,1))
x <- irt.model(people, items, responses, "3PL")
x
x$probability(x)
x$information(x)
x$likelihood(x)
# create a 3PL model with generated data
x <- irt.model(model="3pl")$gen.data(20, 5)
x
x$probability(x)
x$information(x)
x$likelihood(x)
# Generate Rasch items
irt.model(model="3pl")$gen.data(20, 5, a.mu=0, a.sig=0, c.alpha=0, c.beta=0)
# Generate an 3PL item pool
irt.model(model="3pl")$gen.data(1, 100)$items
# Generate responses using given people and item parameters
irt.model(model="3pl")$gen.data(people=people, items=items)$responses
# create 3pl model using parameter vectors
irt.model.3pl.init(people$theta, items$a, items$b, items$c, responses)
irt.model.3pl.init(people$theta, .58, items$b, 0, NULL)
 
# compute probability, information, likelihood and loglikelihood
x <- irt.model(model="3pl")$gen.data(20, 5)
irt.stats(x, "probability")
irt.stats(x, "probability", "people", sum)
irt.stats(x, "information")
irt.stats(x, "information", "items", sum)
irt.stats(x, "likelihood")
irt.stats(x, "likelihood", "people", prod)
log(irt.stats(x, "likelihood", "people", prod))
irt.stats(x, "loglikelihood", "people", sum)
# plot probability, information and log-likelihood
x <- irt.model(model="3pl")$gen.data(20, 5)
plot(x, stats="probability")
plot(x, stats="probability", total=FALSE)
plot(x, stats="information")
plot(x, stats="information", total=FALSE)
plot(irt.sample(x, n.people=1), stats="loglikelihood")
# select from an IRT model
irt.select(x, people.index=c(1,3,5))
irt.select(x, items.index=c(1,3,5))
# sample wihtout replacement from an IRT model
irt.sample(x, n.people=3)
irt.sample(x, n.items=3)
# sample with replacement from an IRT model
irt.sample(x, n.people=30)
irt.sample(x, n.items=30)
# rescale theta
x <- irt.model(model="3pl")$gen.data(5,3)
c(mean(x$people$theta), sd(x$people$theta))
y <- irt.rescale.3pl(x, "theta", 0, 1)
c(mean(y$people$theta), sd(y$people$theta))
irt.stats(x, "probability")
irt.stats(y, "probability")
# rescale b
x <- irt.model(model="3pl")$gen.data(5,3)
c(mean(x$items$b), sd(x$items$b))
y <- irt.rescale.3pl(x, "b", 0, 1)
c(mean(y$items$b), sd(y$items$b))
irt.stats(x, "probability")
irt.stats(y, "probability")
}

