% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xpose.log.axes.R
\name{xpose.logTicks}
\alias{xpose.logTicks}
\alias{xpose.yscale.components.log10}
\alias{xpose.xscale.components.log10}
\title{Functions to create nice looking axes when using Log scales.}
\usage{
xpose.logTicks(lim, loc = c(1, 5))

xpose.yscale.components.log10(lim, ...)

xpose.xscale.components.log10(lim, ...)
}
\arguments{
\item{lim}{Limits}

\item{loc}{Locations}

\item{\dots}{Additional arguments passed to the function.}
}
\description{
The functions are used to create standard tic marks and axis labels when the
axes are on the log scale.
}
\details{
These functions create log scales that look like they should (not the
default R scales). These functions are used as input to the
\code{\link[lattice:axis.default]{xscale.components}} argument in a lattice
plot.
}
\section{Functions}{
\itemize{
\item \code{xpose.logTicks}: Make log tic marks

\item \code{xpose.xscale.components.log10}: Make log scale on x-axis
}}

\examples{

\dontrun{
xpdb5 <- xpose.data(5)
xpose.plot.default("PRED","DV",xpdb,logy=T,logx=T)
xpose.plot.default("PRED","DV",xpdb,logy=T,logx=T,
                   yscale.components = xpose.yscale.components.log10,
                   xscale.components = xpose.xscale.components.log10)

## both give the same result
}

}
\seealso{
\code{\link{xpose.plot.default}}
\code{\link[lattice:axis.default]{xscale.components}}
}
\author{
Andrew Hooker
}
\keyword{methods}
