% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/npc.coverage.R
\name{npc.coverage}
\alias{npc.coverage}
\title{Function to plot the coverage of the Numerical Predictive Check}
\usage{
npc.coverage(
  npc.info = "npc_results.csv",
  main = "Default",
  main.sub = NULL,
  main.sub.cex = 0.85,
  ...
)
}
\arguments{
\item{npc.info}{The results file from the \code{npc} command in PsN. For
example, \file{npc_results.csv}, or if the file is in a separate directory
\file{./npc_dir1/npc_results.csv}.}

\item{main}{A string giving the plot title or \code{NULL} if none.
\code{"Default"} creates a default title.}

\item{main.sub}{Used for names above each plot when using multiple plots.
Should be a vector \code{c("Group 1","Group 2")}}

\item{main.sub.cex}{The size of the \code{main.sub} titles.}

\item{\dots}{Other arguments passed to
\code{\link{xpose.multiple.plot.default}}, \code{\link[lattice]{xyplot}} and
others. Please see these functions (and below) for more descriptions of what you can do.}
}
\value{
A list of plots
}
\description{
This function takes the output from the \code{npc} command in Perl Speaks
NONMEM (PsN) and makes a coverage plot.  A coverage plot for the NPC looks
at different prediction intervals (PIs) for each data point and calculates
the total number of data points in the data set lying outside of these PIs.
The plot shows the relative amount of data points outside of their PI
compared to the expected amount at that PI.  In addition a confidence
interval around these values are computed based on the simulated data.
}
\section{Additional arguments for the NPC coverage plots}{


\strong{Additional plot features}

\describe{ 
\item{\code{CI}}{Specifies
whether confidence intervals (as lines, a shaded area or both) should be
added to the plot. Allowed values are: \code{"area"}, 
\code{"lines"}, \code{"both"}, or \code{NULL}.} 
\item{\code{mark.outside.data}}{Should the points outside the CI be marked in a different
color to identify them. Allowed values are \code{TRUE} or \code{FALSE}.} 
\item{\code{abline}}{Should there be a line
to mark the value of y=1? Possible values are \code{TRUE}, \code{FALSE} and
\code{NULL}.}
}

\strong{Line and area control. See \code{\link[graphics]{plot}},
\code{\link[grid]{grid.polygon}} and \code{\link[lattice]{xyplot}} for more
details.}

\describe{ \item{\code{CI.area.col}}{Color of the area
for the CI. Defaults to \code{"blue"}} 
\item{\code{CI.area.alpha}}{Transparency of the \code{CI.area.col}. Defaults to 0.3.}
\item{\code{ab.lwd}}{The width of the abline. Default is 1.}
\item{\code{ab.lty}}{Line type of the abline. Default is \code{"dashed"}}
\item{\code{CI.upper.lty}}{Line type of the line at the upper
edge of the CI.}
\item{\code{CI.upper.col}}{Color of the line at the upper edge of the CI.} 
\item{\code{CI.upper.lwd}}{The line width of
the line at the upper edge of the CI.} 
\item{\code{CI.lower.lty}}{The line type at
the lower edge of the CI.}
\item{\code{CI.lower.col}}{The color of the line at the
lower edge of the CI.}
\item{\code{CI.lower.lwd}}{The line width of the line at the lower
edge of the CI.}
\item{\code{obs.col}}{The color of the observed values.}
\item{\code{obs.pch}}{The type of point to use for the observed values.}
\item{\code{obs.lty}}{The type of line to use for the observed values.} 
\item{\code{obs.type}}{The combination of lines and points
to use for the observed values. Default is \code{"b"} for both.} 
\item{\code{obs.cex}}{The size of the
points to use for the observed values.} 
\item{\code{obs.lwd}}{The line
width to use for the observed values.} 
\item{\code{out.col}}{The color of the observed values that lie outside of the CI. Only used if
\code{mark.outside.data=TRUE}.} 
\item{\code{out.pch}}{The type of point
to use for the observed values that lie outside of the CI. Only used if
\code{mark.outside.data = TRUE}.} 
\item{\code{out.cex}}{The size of the
points of the observed values that lie outside of the CI. Only used if
\code{mark.outside.data = TRUE}.} 
\item{\code{out.lwd}}{The line width of
the observed values that lie outside of the CI. Only used if
\code{mark.outside.data = TRUE}.} }
}

\examples{

\dontrun{
library(xpose4)

npc.coverage()

## to read files in a directory different than the current working directory 
npc.file <- "./another_directory/npc_results.csv"
npc.coverage(npc.info=npc.file)
}

}
\seealso{
\code{\link{read.npc.vpc.results}}
\code{\link{xpose.multiple.plot.default}} \code{\link[lattice]{xyplot}}

Other PsN functions: 
\code{\link{boot.hist}()},
\code{\link{bootscm.import}()},
\code{\link{randtest.hist}()},
\code{\link{read.npc.vpc.results}()},
\code{\link{read.vpctab}()},
\code{\link{xpose.VPC.both}()},
\code{\link{xpose.VPC.categorical}()},
\code{\link{xpose.VPC}()},
\code{\link{xpose4-package}}
}
\author{
Andrew Hooker
}
\concept{PsN functions}
\keyword{methods}
