% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reset.graph.par.R
\name{reset.graph.par}
\alias{reset.graph.par}
\title{Resets Xpose variable definitions to factory settings}
\usage{
reset.graph.par(object, classic = FALSE)
}
\arguments{
\item{object}{An \code{xpose.data} object.}

\item{classic}{A logical operator specifying whether the function should
assume the classic menu system. This is an internal option and need never be
called from the command line.}
}
\value{
An \code{\link{xpose.data}} object (classic == FALSE) or null
(classic == TRUE).
}
\description{
Function to reset Xpose's graphics parameters definitions to the default.
}
\details{
This functions is used to reset Xpose's graphic settings definitions to
their default values. Graphical settings are read from the file 'xpose.ini'
in the root of the 'xpose4' package.
}
\examples{

\dontrun{
## xpdb5 is an Xpose data object
## We expect to find the required NONMEM run and table files for run
## 5 in the current working directory
xpdb5 <- xpose.data(5)

## Import graphics preferences you saved earlier using export.graph.par
xpdb5 <- import.graph.par(xpdb5)

## Reset to default values
xpdb5 <- reset.graph.par(xpdb5)

## Change WRES definition
xpdb5 <- change.wres(xpdb5)
}

}
\seealso{
\code{\link{xpose.prefs-class}}, \code{\link{import.graph.par}},
\code{\link{change.xvardef}}
}
\author{
Niclas Jonsson & Justin Wilkins
}
\keyword{methods}
