% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fixes.R
\name{irep}
\alias{irep}
\title{Add simulation counter}
\usage{
irep(x, quiet = FALSE)
}
\arguments{
\item{x}{The column to be used for computing simulation number, usually the ID column.}

\item{quiet}{Logical, if \code{FALSE} messages are printed to the console.}
}
\value{
\verb{<numeric>} vector tracking the number of simulations based on unique subject IDs.
}
\description{
Add a column containing a simulation counter (irep). A new simulation is counted every time
a value in x is different than its previous value and is a duplicate.

This version of the function does not require IDs be ascending, but does not work for
datasets where IDs are repeated (not in sequence). Both cases are read as separate
individuals for NONMEM, but NONMEM does not need to detect repetition of ID sequences (for NONMEM,
\code{1,1,2,2,3,3,1,1,2,2,3,3} is 6 individuals, regardless of being 2 repeats of 3 individuals).
Given the vast majority of datasets use 1 individual per ID, (which cannot be said about IDs
always being ascending), only one of these corrections is implemented.
}
\details{
Bugfix for \code{\link[xpose]{irep}}.
}
\examples{
data("xpdb_ex_pk", package = "xpose")

xpdb_ex_pk_2 <- xpdb_ex_pk \%>\%
 mutate(sim_id = irep(ID), .problem = 2)

}
