% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/options.R
\name{xportr_options}
\alias{xportr_options}
\title{Get or set xportr options}
\usage{
xportr_options(...)
}
\arguments{
\item{...}{Options to set, with the form \code{name = value} or a character vector of option names.}
}
\description{
There are two mechanisms for working with options for xportr. One is the
\code{\link[=options]{options()}} function, which is part of base R, and the other is the
\code{xportr_options()} function, which is in the xportr package. The reason for
these two mechanisms is has to do with legacy code and scoping.

The \code{\link[=options]{options()}} function sets options globally, for the duration of the R
process. The \code{\link[=getOption]{getOption()}} function retrieves the value of an option. All
xportr related options of this type are prefixed with \code{"xportr."}.
}
\section{Options with \code{options()}}{


\describe{
\item{xportr.df_domain_name}{defaults to \code{"dataset"}\cr
The name of the domain "name" column in dataset metadata.}
\item{xportr.df_label}{defaults to \code{"label"}\cr
The column noting the dataset label in dataset metadata.}
\item{xportr.domain_name}{defaults to \code{"dataset"}\cr
The name of the domain "name" column in variable metadata.}
\item{xportr.variable_name}{defaults to \code{"variable"}\cr
The name of the variable "name" in variable metadata.}
\item{xportr.type_name}{defaults to \code{"type"}\cr
The name of the variable type column in variable metadata.}
\item{xportr.label}{defaults to \code{"label"}\cr
The name of the variable label column in variable metadata.}
\item{xportr.length}{defaults to \code{"length"}\cr
The name of the variable length column in variable metadata.}
\item{xportr.order_name}{defaults to \code{"order"}\cr
The name of the variable order column in variable metadata.}
\item{xportr.format_name}{defaults to \code{"format"}\cr
The name of the variable format column in variable metadata.}
\item{xportr.format_verbose}{defaults to \code{"none"}\cr
The default argument for the 'verbose' argument for \code{xportr_format}.}
\item{xportr.label_verbose}{defaults to \code{"none"}\cr
The default argument for the 'verbose' argument for \code{xportr_label}.}
\item{xportr.length_verbose}{defaults to \code{"none"}\cr
The default argument for the 'verbose' argument for \code{xportr_length}.}
\item{xportr.type_verbose}{defaults to \code{"label"}\cr
The default argument for the 'verbose' argument for \code{xportr_type}.}
\item{xportr.character_types}{defaults to \code{"character"}\cr
The default character vector used to explicitly coerce R classes to character XPT types.}
\item{xportr.character_metadata_types}{defaults to \code{c("character", "char", "text", "date", "posixct", "posixt", "datetime", "time", "partialdate", "partialtime", "partialdatetime", "incompletedatetime", "durationdatetime", "intervaldatetime")}\cr
The default character vector used to explicitly coerce R classes to character XPT types.}
\item{xportr.numeric_metadata_types}{defaults to \code{c("integer", "numeric", "num", "float")}\cr
The default character vector used to explicitly coerce R classes to numeric XPT types.}
\item{xportr.numeric_types}{defaults to \code{c("integer", "float", "numeric", "posixct", "posixt", "time", "date", "hms")}\cr
The default character vector used to explicitly coerce R classes to numeric XPT types.}
}
}

\section{Options with \code{xportr_options()}}{


Alternative to the \code{options()}, the \code{xportr_options()} function can be used to set the options.
The \code{xportr_options()} function also returns the current options when a character vector of
the options keys are passed into it. If nothing is passed into it, it returns the state of all xportr options.
}

\examples{
xportr_options("xportr.df_label")
xportr_options(xportr.df_label = "data_label", xportr.label = "custom_label")
xportr_options(c("xportr.label", "xportr.df_label"))
xportr_options()
}
