library(xpectr)
context("prepare_insertion()")

test_that("prepare_insertion() works", {

  df_expectations <- list(
    " ",
    "## Testing 'df'                                                             ####",
    "## Initially generated by xpectr",
    "xpectr::set_test_seed(42)",
    "# Testing class",
    "expect_equal(\n  class(df),\n  c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data.frame\"),\n  fixed = TRUE)",
    "# Testing column values",
    "expect_equal(\n  df[[\"a\"]],\n  c(1, 2, 3),\n  tolerance = 1e-4)",
    "expect_equal(\n  df[[\"b\"]],\n  c(\"t\", \"y\", \"u\"),\n  fixed = TRUE)",
    "expect_equal(\n  df[[\"c\"]],\n  structure(1:3, levels = c(\"a\", \"b\", \"c\"), class = \"factor\"))",
    "# Testing column names",
    "expect_equal(\n  names(df),\n  c(\"a\", \"b\", \"c\"),\n  fixed = TRUE)",
    "# Testing column classes",
    "expect_equal(\n  xpectr::element_classes(df),\n  c(\"numeric\", \"character\", \"factor\"),\n  fixed = TRUE)",
    "# Testing column types",
    "expect_equal(\n  xpectr::element_types(df),\n  c(\"double\", \"character\", \"integer\"),\n  fixed = TRUE)",
    "# Testing dimensions",
    "expect_equal(\n  dim(df),\n  c(3L, 3L))",
    "# Testing group keys",
    "expect_equal(\n  colnames(dplyr::group_keys(df)),\n  \"a\",\n  fixed = TRUE)",
    "## Finished testing 'df'                                                    ####",
    " "
  )

  df_expectations_indented <- list(
    " ",
    "## Testing 'df'                                                       ####",
    "## Initially generated by xpectr",
    "xpectr::set_test_seed(42)",
    "# Testing class",
    "expect_equal(\n  class(df),\n  c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data.frame\"),\n  fixed = TRUE)",
    "# Testing column values",
    "expect_equal(\n  df[[\"a\"]],\n  c(1, 2, 3),\n  tolerance = 1e-4)",
    "expect_equal(\n  df[[\"b\"]],\n  c(\"t\", \"y\", \"u\"),\n  fixed = TRUE)",
    "expect_equal(\n  df[[\"c\"]],\n  structure(1:3, levels = c(\"a\", \"b\", \"c\"), class = \"factor\"))",
    "# Testing column names",
    "expect_equal(\n  names(df),\n  c(\"a\", \"b\", \"c\"),\n  fixed = TRUE)",
    "# Testing column classes",
    "expect_equal(\n  xpectr::element_classes(df),\n  c(\"numeric\", \"character\", \"factor\"),\n  fixed = TRUE)",
    "# Testing column types",
    "expect_equal(\n  xpectr::element_types(df),\n  c(\"double\", \"character\", \"integer\"),\n  fixed = TRUE)",
    "# Testing dimensions",
    "expect_equal(\n  dim(df),\n  c(3L, 3L))",
    "# Testing group keys",
    "expect_equal(\n  colnames(dplyr::group_keys(df)),\n  \"a\",\n  fixed = TRUE)",
    "## Finished testing 'df'                                              ####",
    " "
  )

  expect_equal(prepare_insertion(df_expectations),
               paste0("\n## Testing 'df'                                          ",
                      "                   ####\n## Initially generated by xpectr\nx",
                      "pectr::set_test_seed(42)\n# Testing class\nexpect_equal(\n  ",
                      "class(df),\n  c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data.",
                      "frame\"),\n  fixed = TRUE)\n# Testing column values\nexpect_",
                      "equal(\n  df[[\"a\"]],\n  c(1, 2, 3),\n  tolerance = 1e-4)\n",
                      "expect_equal(\n  df[[\"b\"]],\n  c(\"t\", \"y\", \"u\"),\n  ",
                      "fixed = TRUE)\nexpect_equal(\n  df[[\"c\"]],\n  structure(1:",
                      "3, levels = c(\"a\", \"b\", \"c\"), class = \"factor\"))\n# ",
                      "Testing column names\nexpect_equal(\n  names(df),\n  c(\"a\"",
                      ", \"b\", \"c\"),\n  fixed = TRUE)\n# Testing column classes",
                      "\nexpect_equal(\n  xpectr::element_classes(df),\n  c(\"numeri",
                      "c\", \"character\", \"factor\"),\n  fixed = TRUE)\n# Testing",
                      " column types\nexpect_equal(\n  xpectr::element_types(df),\n",
                      "  c(\"double\", \"character\", \"integer\"),\n  fixed = TRUE",
                      ")\n# Testing dimensions\nexpect_equal(\n  dim(df),\n  c(3L, ",
                      "3L))\n# Testing group keys\nexpect_equal(\n  colnames(dplyr:",
                      ":group_keys(df)),\n  \"a\",\n  fixed = TRUE)\n## Finished te",
                      "sting 'df'                                                  ",
                      "  ####\n"))

  # Should have fewer spaces before "####"
  expect_equal(prepare_insertion(df_expectations_indented),
               paste0("\n## Testing 'df'                                          ",
                      "             ####\n## Initially generated by xpectr\nxpectr:",
                      ":set_test_seed(42)\n# Testing class\nexpect_equal(\n  class(",
                      "df),\n  c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data.frame",
                      "\"),\n  fixed = TRUE)\n# Testing column values\nexpect_equal(",
                      "\n  df[[\"a\"]],\n  c(1, 2, 3),\n  tolerance = 1e-4)\nexpect",
                      "_equal(\n  df[[\"b\"]],\n  c(\"t\", \"y\", \"u\"),\n  fixed ",
                      "= TRUE)\nexpect_equal(\n  df[[\"c\"]],\n  structure(1:3, levels",
                      " = c(\"a\", \"b\", \"c\"), class = \"factor\"))\n# Testin",
                      "g column names\nexpect_equal(\n  names(df),\n  c(\"a\", \"b",
                      "\", \"c\"),\n  fixed = TRUE)\n# Testing column classes\nexpec",
                      "t_equal(\n  xpectr::element_classes(df),\n  c(\"numeric\", ",
                      "\"character\", \"factor\"),\n  fixed = TRUE)\n# Testing colum",
                      "n types\nexpect_equal(\n  xpectr::element_types(df),\n  c(\"",
                      "double\", \"character\", \"integer\"),\n  fixed = TRUE)\n# T",
                      "esting dimensions\nexpect_equal(\n  dim(df),\n  c(3L, 3L))\n",
                      "# Testing group keys\nexpect_equal(\n  colnames(dplyr::group",
                      "_keys(df)),\n  \"a\",\n  fixed = TRUE)\n## Finished testing ",
                      "'df'                                              ####\n"))

  expect_equal(strip(prepare_insertion(df_expectations_indented)),
               strip(prepare_insertion(df_expectations)))

  expect_equal(prepare_insertion(df_expectations, indentation = 6),
               paste0("\n      ## Testing 'df'                                    ",
                      "                         ####\n      ## Initially generated ",
                      "by xpectr\n      xpectr::set_test_seed(42)\n      # Testing ",
                      "class\n      expect_equal(\n        class(df),\n        c(\"",
                      "grouped_df\", \"tbl_df\", \"tbl\", \"data.frame\"),\n       ",
                      " fixed = TRUE)\n      # Testing column values\n      expect_",
                      "equal(\n        df[[\"a\"]],\n        c(1, 2, 3),\n        t",
                      "olerance = 1e-4)\n      expect_equal(\n        df[[\"b\"]],",
                      "\n        c(\"t\", \"y\", \"u\"),\n        fixed = TRUE)\n   ",
                      "   expect_equal(\n        df[[\"c\"]],\n        structure(1:",
                      "3, levels = c(\"a\", \"b\", \"c\"), class = \"factor\"))\n  ",
                      "    # Testing column names\n      expect_equal(\n        nam",
                      "es(df),\n        c(\"a\", \"b\", \"c\"),\n        fixed = TR",
                      "UE)\n      # Testing column classes\n      expect_equal(\n  ",
                      "      xpectr::element_classes(df),\n        c(\"numeric\", ",
                      "\"character\", \"factor\"),\n        fixed = TRUE)\n      # T",
                      "esting column types\n      expect_equal(\n        xpectr::el",
                      "ement_types(df),\n        c(\"double\", \"character\", \"int",
                      "eger\"),\n        fixed = TRUE)\n      # Testing dimensions",
                      "\n      expect_equal(\n        dim(df),\n        c(3L, 3L))\n",
                      "      # Testing group keys\n      expect_equal(\n        col",
                      "names(dplyr::group_keys(df)),\n        \"a\",\n        fixed",
                      " = TRUE)\n      ## Finished testing 'df'                    ",
                      "                                ####\n      "))

  expect_equal(prepare_insertion(paste0("   ", df_expectations), indentation = 6, trim_left = TRUE),
               paste0("## Testing 'df'                                            ",
                      "                 ####\n         ## Initially generated by xp",
                      "ectr\n         xpectr::set_test_seed(42)\n         # Testing",
                      " class\n         expect_equal(\n        class(df),\n        ",
                      "c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data.frame\"),\n   ",
                      "     fixed = TRUE)\n         # Testing column values\n      ",
                      "   expect_equal(\n        df[[\"a\"]],\n        c(1, 2, 3),",
                      "\n        tolerance = 1e-4)\n         expect_equal(\n        ",
                      "df[[\"b\"]],\n        c(\"t\", \"y\", \"u\"),\n        fixed",
                      " = TRUE)\n         expect_equal(\n        df[[\"c\"]],\n    ",
                      "    structure(1:3, levels = c(\"a\", \"b\", \"c\"), class = ",
                      "\"factor\"))\n         # Testing column names\n         expe",
                      "ct_equal(\n        names(df),\n        c(\"a\", \"b\", \"c\"",
                      "),\n        fixed = TRUE)\n         # Testing column classes",
                      "\n         expect_equal(\n        xpectr::element_classes(df",
                      "),\n        c(\"numeric\", \"character\", \"factor\"),\n    ",
                      "    fixed = TRUE)\n         # Testing column types\n        ",
                      " expect_equal(\n        xpectr::element_types(df),\n        ",
                      "c(\"double\", \"character\", \"integer\"),\n        fixed = ",
                      "TRUE)\n         # Testing dimensions\n         expect_equal(",
                      "\n        dim(df),\n        c(3L, 3L))\n         # Testing g",
                      "roup keys\n         expect_equal(\n        colnames(dplyr::g",
                      "roup_keys(df)),\n        \"a\",\n        fixed = TRUE)\n    ",
                      "     ## Finished testing 'df'                               ",
                      "                     ####\n          "))

  expect_equal(prepare_insertion(paste0("   ", df_expectations), indentation = 6, trim_right = TRUE),
               paste0("    \n         ## Testing 'df'                             ",
                      "                                ####\n         ## Initially ",
                      "generated by xpectr\n         xpectr::set_test_seed(42)\n   ",
                      "      # Testing class\n         expect_equal(\n        class",
                      "(df),\n        c(\"grouped_df\", \"tbl_df\", \"tbl\", \"data",
                      ".frame\"),\n        fixed = TRUE)\n         # Testing column",
                      " values\n         expect_equal(\n        df[[\"a\"]],\n     ",
                      "   c(1, 2, 3),\n        tolerance = 1e-4)\n         expect_e",
                      "qual(\n        df[[\"b\"]],\n        c(\"t\", \"y\", \"u\"),",
                      "\n        fixed = TRUE)\n         expect_equal(\n        df[",
                      "[\"c\"]],\n        structure(1:3, levels = c(\"a\", \"b\", ",
                      "\"c\"), class = \"factor\"))\n         # Testing column names",
                      "\n         expect_equal(\n        names(df),\n        c(\"a",
                      "\", \"b\", \"c\"),\n        fixed = TRUE)\n         # Testing",
                      " column classes\n         expect_equal(\n        xpectr::ele",
                      "ment_classes(df),\n        c(\"numeric\", \"character\", \"f",
                      "actor\"),\n        fixed = TRUE)\n         # Testing column ",
                      "types\n         expect_equal(\n        xpectr::element_types",
                      "(df),\n        c(\"double\", \"character\", \"integer\"),\n ",
                      "       fixed = TRUE)\n         # Testing dimensions\n       ",
                      "  expect_equal(\n        dim(df),\n        c(3L, 3L))\n     ",
                      "    # Testing group keys\n         expect_equal(\n        co",
                      "lnames(dplyr::group_keys(df)),\n        \"a\",\n        fixe",
                      "d = TRUE)\n         ## Finished testing 'df'                ",
                      "                                    ####"))


})
