% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/do_if.R
\name{stop_if}
\alias{stop_if}
\alias{warn_if}
\alias{message_if}
\title{Simple side effect functions}
\usage{
stop_if(condition, message = NULL, sys.parent.n = 0L)

warn_if(condition, message = NULL, sys.parent.n = 0L)

message_if(condition, message = NULL, sys.parent.n = 0L)
}
\arguments{
\item{condition}{The condition to check. (Logical)}

\item{message}{Message. (Character)

Note: If \code{NULL}, the \code{`condition`} will be used as message.}

\item{sys.parent.n}{The number of generations to go back when calling the message function.}
}
\value{
Returns \code{NULL} invisibly.
}
\description{
\Sexpr[results=rd, stage=render]{lifecycle::badge("experimental")}

If the \code{`condition`} is \code{TRUE},
generate \code{error}/\code{warning}/\code{message} with the supplied message.
}
\details{
When \code{`condition`} is \code{FALSE}, they return \code{NULL} invisibly.

When \code{`condition`} is \code{TRUE}:

\subsection{stop_if()}{
Throws error with the supplied message.
}
\subsection{warn_if()}{
Throws warning with the supplied message.
}
\subsection{message_if()}{
Generates message with the supplied message.
}
}
\examples{
# Attach packages
library(xpectr)
\dontrun{
a <- 0
stop_if(a == 0, "'a' cannot be 0.")
warn_if(a == 0, "'a' was 0.")
message_if(a == 0, "'a' was so kind to be 0.")
}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
