% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/side_effects.R
\name{capture_side_effects}
\alias{capture_side_effects}
\title{Capture side effects}
\usage{
capture_side_effects(
  expr,
  envir = NULL,
  copy_env = FALSE,
  reset_seed = FALSE,
  disable_crayon = TRUE
)
}
\arguments{
\item{expr}{Expression.}

\item{envir}{Environment to evaluate in. Defaults to
\code{\link[base:sys.parent]{parent.frame()}}.}

\item{copy_env}{Whether to use deep copies of the environment when capturing side effects. (Logical)

Disabled by default to save memory but is often preferable to enable, e.g. when the function
alters non-local variables before throwing its \code{error}/\code{warning}/\code{message}.}

\item{reset_seed}{Whether to reset the random state on exit. (Logical)}

\item{disable_crayon}{Whether to disable \code{crayon} formatting.
This can remove ANSI characters from the messages. (Logical)}
}
\value{
\code{named list} with the side effects.
}
\description{
Captures \code{error}s, \code{warning}s, and \code{message}s from an expression.

In case of an \code{error}, no other side effects are captured.

Simple wrapper for \code{testthat}'s
\code{\link[testthat:capture_condition]{capture_error()}},
\code{\link[testthat:capture_condition]{capture_warnings()}} and
\code{\link[testthat:capture_condition]{capture_messages()}}.

Note: Evaluates \code{expr} up to three times.
}
\examples{
# Attach packages
library(xpectr)

fn <- function(raise = FALSE){
  message("Hi! I'm Kevin, your favorite message!")
  warning("G'Day Mam! I'm a warning to the world!")
  message("Kevin is ma name! Yesss!")
  warning("Hopefully the whole world will see me :o")
  if (isTRUE(raise)){
    stop("Lord Evil Error has arrived! Yeehaaa")
  }
  "the output"
}
\donttest{
capture_side_effects(fn())
capture_side_effects(fn(raise = TRUE))
capture_side_effects(fn(raise = TRUE), copy_env = TRUE)
}
}
\seealso{
Other capturers: 
\code{\link{capture_parse_eval_side_effects}()}
}
\author{
Ludvig Renbo Olsen, \email{r-pkgs@ludvigolsen.dk}
}
\concept{capturers}
