% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xmp.R
\name{xmp}
\alias{xmp}
\title{XMP metadata object}
\usage{
xmp(
  ...,
  alt_text = NULL,
  attribution_name = NULL,
  attribution_url = NULL,
  create_date = NULL,
  creator = NULL,
  creator_tool = NULL,
  credit = NULL,
  date_created = NULL,
  description = NULL,
  ext_description = NULL,
  headline = NULL,
  keywords = NULL,
  license = NULL,
  marked = NULL,
  modify_date = NULL,
  more_permissions = NULL,
  producer = NULL,
  rights = NULL,
  subject = NULL,
  title = NULL,
  usage_terms = NULL,
  web_statement = NULL,
  auto_xmp = c("cc:attributionName", "cc:license", "dc:rights", "dc:subject",
    "photoshop:Credit", "xmpRights:Marked", "xmpRights:UsageTerms",
    "xmpRights:WebStatement"),
  spdx_id = NULL
)
}
\arguments{
\item{...}{Entries of xmp metadata.  The names are either the xmp tag names or alternatively the xmp namespace and tag names separated by ":".  The values are the xmp values.}

\item{alt_text}{Brief textual description that can be used as its "alt text" (XMP tag \code{Iptc4xmpCore:AltTextAccessibility}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Core IPTC photo metadata.}

\item{attribution_name}{The name to be used when attributing the work (XMP tag \code{cc:attributionName}).
Recommended by Creative Commons.
If missing and \code{"cc:attributionName"} in \code{auto_xmp} and
and \code{photoshop:Credit} non-missing will use that else if \code{dc:creator} non-missing
then will automatically use \code{paste(creator, collapse = " and ")}.}

\item{attribution_url}{The URL to be used when attributing the work (XMP tag \code{cc:attributionURL}).
Recommended by Creative Commons.}

\item{create_date}{The date the digital document was created (XMP tag \code{xmp:CreateDate}).
Will be coerced by \code{\link[datetimeoffset:as_datetimeoffset]{datetimeoffset::as_datetimeoffset()}}.
Related pdf documentation info key is \code{CreationDate}.
Not to be confused with \code{photoshop:DateCreated} which is the
date the intellectual content was created.}

\item{creator}{The document's author(s) (XMP tag \code{dc:creator}).
Related pdf documentation info key is \code{Author}.
Core IPTC photo metadata used by Google Photos.
If \code{credit} is missing and \code{"photoshop:Credit"} in \code{auto_xmp} then
we'll also use this for the \code{photoshop:Credit} XMP tag.}

\item{creator_tool}{The name of the application that originally created the document (XMP tag \code{xmp:CreatorTool}).
Related pdf documentation info key is \code{Creator}.}

\item{credit}{Credit line field (XMP tag \code{photoshop:Credit}).
Core IPTC photo metadata used by Google Photos.
If missing and \code{"photoshop:Credit"} in \code{auto_xmp} and \code{dc:creator} non-missing
then will automatically use \code{paste(creator, collapse = " and ")}.}

\item{date_created}{The date the intellectual content was created (XMP tag \code{photoshop:DateCreated}).
Will be coerced by \code{\link[datetimeoffset:as_datetimeoffset]{datetimeoffset::as_datetimeoffset()}}.
Core IPTC photo metadata.
Not to be confused with \code{xmp:CreateDate} for when the digital document was created.}

\item{description}{The document's subject (XMP tag \code{dc:description}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Core IPTC photo metadata.
Related pdf documentation info key is \code{Subject}.}

\item{ext_description}{An extended description (for accessibility)
if the "alt text" is insufficient (XMP tag \code{Iptc4xmpCore:ExtDescrAccessibility}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Core IPTC photo metadata.}

\item{headline}{A short synopsis of the document (XMP tag \code{photoshop:Headline}).
Core IPTC photo metadata.}

\item{keywords}{Character vector of keywords for this document (for cross-document searching).
Related pdf documentation info key is \code{pdf:Keywords}.
Will be coerced into a string by \code{paste(keywords, collapse = ", ")}.}

\item{license}{The URL of (open source) license terms (XMP tag \code{cc:license}).
Recommended by Creative Commons.
Note \code{xmpRights:WebStatement} set in \code{web_statement} is a more popular XMP tag (e.g. used by Google Images)
that can also hold the URL of license terms or a verifying web statement.
If \code{cc:license} in \code{auto_xmp} and \code{spdx_id} is not \code{NULL} then
we'll automatically use an URL from \link{spdx_licenses} corresponding to that license.}

\item{marked}{Whether the document is a rights-managed resource (XMP tag \code{xmpRights:Marked}).
Use \code{TRUE} if rights-managed, \code{FALSE} if public domain, and \code{NULL} if unknown.
Creative Commons recommends setting this.
If \code{xmpRights:Marked} in \code{auto_xmp} and \code{spdx_id} is not \code{NULL} then
we can automatically set this for a subset of SPDX licenses (including all Creative Commons licenses).}

\item{modify_date}{The date the document was last modified (XMP tag \code{xmp:ModifyDate}).
Will be coerced by \code{\link[datetimeoffset:as_datetimeoffset]{datetimeoffset::as_datetimeoffset()}}.
Related pdf documentation info key is \code{ModDate}.}

\item{more_permissions}{A URL for additional permissions beyond the \code{license} (XMP tag \code{cc:morePermissions}).
Recommended by Creative Commons.
Contrast with the \code{LicensorURL} property of \code{plus:Licensor} XMP tag.}

\item{producer}{The name of the application that converted the document to pdf (XMP tag \code{pdf:Producer}).
Related pdf documentation info key is \code{Producer}.}

\item{rights}{(copy)right information about the document (XMP tag \code{dc:rights}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Core IPTC photo metadata used by Google Photos that Creative Commons also recommends setting.
If \code{dc:rights} in \code{auto_xmp} and \code{creator} and \code{date_created} are not \code{NULL} then
we can automatically generate a basic copyright statement with the help of \code{spdx_id}.}

\item{subject}{List of description phrases, keywords, classification codes (XMP tag \code{dc:subject}).
Core IPTC photo metadata.
A character vector.
Similar but less popular to the XMP tag \code{pdf:Keywords} which is a string.
If \code{dc:subject} in \code{auto_xmp} and \code{keywords} is not NULL then we can
automatically extract the keywords from it using \code{strsplit(keywords, ", ")[[1]]}.}

\item{title}{The document's title (XMP tag \code{dc:title}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Related pdf documentation info key is \code{Title}.}

\item{usage_terms}{A string describing legal terms of use for the document (XMP tag \code{xmpRights:UsageTerms}).
Will be coerced by \code{\link[=as_lang_alt]{as_lang_alt()}}.
Core IPTC photo metadata and recommended by Creative Commons.
If \code{xmpRights:UsageTerms} in \code{auto_xmp} and \code{spdx_id} is not \code{NULL} then
we can automatically set this with that license's name and URL.}

\item{web_statement}{Web Statement of Rights (XMP tag \code{xmpRights:WebStatement}):
a string of a full URL with license information about the page.
If \code{xmpRights:WebStatement} in \code{auto_xmp} and \code{spdx_id} is not \code{NULL} then
we'll automatically use an URL from \link{spdx_licenses} corresponding to that license.
Core IPTC photo metadata used by Google Photos.
Also recommended by Creative Commons (who also recommends using a "verifying" web statement).}

\item{auto_xmp}{Character vector of XMP metadata we should try to automatically determine
if missing from other XMP metadata and \code{spdx_id}.}

\item{spdx_id}{The id of a license in the SPDX license list.  See \link{spdx_licenses}.}
}
\value{
An xmp object as can be used with \code{\link[=set_xmp]{set_xmp()}}.  Basically a named list whose names are the (optional) xmp namespace and tag names separated by ":" and the values are the xmp values.
Datetimes should be a datetime object such as \code{\link[=POSIXlt]{POSIXlt()}}.
}
\description{
\code{xmp()} creates an XMP metadata object.
Such objects can be used with \code{\link[=set_xmp]{set_xmp()}} to edit XMP medata for a variety of media formats
and such objects are returned by \code{\link[=get_xmp]{get_xmp()}}.
}
\section{\code{xmp} R6 Class Methods}{
\describe{
\item{\code{fig_process(..., auto = c("fig.alt", "fig.cap", "fig.scap"))}}{
Returns a function to embed XMP metadata suitable for use with
\code{{knitr}}'s \code{fig.process} chunk option.
\code{...} are local XMP metadata changes for this function.
\code{auto} are which chunk options should be used to further update metadata values.}
\item{\code{get_item(key)}}{Get XMP metadata value for key \code{key}.
Can also use the relevant active bindings to get more common values.}
\item{\code{print(mode = c("null_omit", "google_images", "creative_commons", "all"), xmp_only = FALSE)}}{
Print out XMP metadata values.  If \code{mode} is "null_omit" print out
which metadata would be embedded.  If \code{mode} is "google images" print out
values for the five fields Google Images uses.  If \code{mode} is \code{creative_commons}
print out the values for the fields Creative Commons recommends be set when
using their licenses.  If mode is \code{all} print out values for all
XMP metadata that we provide active bindings for (even if \code{NULL}).
If \code{xmp_only} is \code{TRUE} then don't print out \code{spdx_id} and \code{auto_xmp} values.}
\item{\code{set_item(key, value)}}{Set XMP metadata key \code{key} with value \code{value}.
Can also use the relevant active bindings to set XMP metadata values.}
\item{\code{update(x)}}{Update XMP metadata entries
using non-\code{NULL} entries in \code{x} coerced by \code{\link[=as_xmp]{as_xmp()}}.}
}
}

\section{\code{xmp} R6 Active Bindings}{
\describe{
\item{\code{alt_text}}{The image's alt text (accessibility).}
\item{\code{attribution_name}}{The name to attribute the document.}
\item{\code{attribution_url}}{The URL to attribute the document.}
\item{\code{create_date}}{The date the document was created.}
\item{\code{creator}}{The document's author.}
\item{\code{creator_tool}}{The name of the application that originally created the document.}
\item{\code{credit}}{Credit line.}
\item{\code{date_created}}{The date the document's intellectual content was created}
\item{\code{description}}{The document's description.}
\item{\code{ext_description}}{An extended description for accessibility.}
\item{\code{headline}}{A short synopsis of document.}
\item{\code{keywords}}{String of keywords for this document (less popular than \code{subject})).}
\item{\code{license}}{URL of (open-source) license terms the document is licensed under.}
\item{\code{marked}}{Boolean of whether this is a rights-managed document.}
\item{\code{modify_date}}{The date the document was last modified.}
\item{\code{more_permissions}}{URL for acquiring additional permissions beyond \code{license}.}
\item{\code{producer}}{The name of the application that converted the document (to pdf).}
\item{\code{rights}}{The document's copy(right) information.}
\item{\code{subject}}{Vector of key phrases/words/codes for this document (more popular than \code{keywords})).}
\item{\code{title}}{The document's title.}
\item{\code{usage_terms}}{The document's rights usage terms.}
\item{\code{web_statement}}{A URL string for the web statement of rights for the document.}
\item{\code{spdx_id}}{The id of a license in the SPDX license list.  See \link{spdx_licenses}.}
\item{\code{auto_xmp}}{Character vector of XMP metadata we should try to automatically determine
if missing from other XMP metadata and \code{spdx_id}.}
}
}

\section{XMP tag recommendations}{

\itemize{
\item \url{https://exiftool.org/TagNames/XMP.html} recommends "dc", "xmp", "Iptc4xmpCore", and "Iptc4xmpExt" schemas if possible
\item \url{https://github.com/adobe/xmp-docs/tree/master/XMPNamespaces} are descriptions of some common XMP tags
\item \url{https://www.iptc.org/std/photometadata/specification/IPTC-PhotoMetadata#xmp-namespaces-and-identifiers} is popular for photos
\item \url{https://developers.google.com/search/docs/appearance/structured-data/image-license-metadata#iptc-photo-metadata} are the subset of IPTC photo metadata which Google Photos uses (if no structured data on web page)
\item \url{https://wiki.creativecommons.org/wiki/XMP} are Creative Commons license recommendations
}
}

\examples{
  x <- xmp(attribution_url = "https://example.com/attribution",
           creator = "John Doe",
           description = "An image caption",
           date_created = Sys.Date(),
           spdx_id = "CC-BY-4.0")
  print(x)
  print(x, mode = "google_images", xmp_only = TRUE)
  print(x, mode = "creative_commons", xmp_only = TRUE)

  if (supports_set_xmp() &&
      supports_get_xmp() &&
      capabilities("png") &&
      requireNamespace("grid", quietly = TRUE)) {

    f <- tempfile(fileext = ".png")
    png(f)
    grid::grid.text("This is an image!")
    invisible(dev.off())
    set_xmp(x, f)
    print(get_xmp(f)[[1]])
  }
}
\seealso{
\code{\link[=get_xmp]{get_xmp()}} and \code{\link[=set_xmp]{set_xmp()}} for getting/setting such information from/to a variety of media file formats.
\code{\link[=as_xmp]{as_xmp()}} for coercing to this object.
\code{\link[=as_docinfo]{as_docinfo()}} can be used to coerce \code{xmp()} objects into \code{\link[=docinfo]{docinfo()}} objects.
}
