% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cat_pages.R
\name{cat_pages}
\alias{cat_pages}
\alias{cat_pages_gs}
\alias{cat_pages_pdftk}
\alias{cat_pages_qpdf}
\title{Concatenate pdf documents together}
\usage{
cat_pages(input, output)

cat_pages_gs(input, output)

cat_pages_pdftk(input, output)

cat_pages_qpdf(input, output)
}
\arguments{
\item{input}{Filename(s) (pdf) to concatenate together}

\item{output}{Filename (pdf) to save concatenated output to}
}
\value{
The (output) filename invisibly.
}
\description{
\code{cat_pages()} concatenates pdf documents together.
}
\details{
\code{cat_pages()} will try to use the following helper functions in the following order:
\enumerate{
\item \code{cat_pages_qpdf()} which wraps \code{\link[qpdf:qpdf]{qpdf::pdf_combine()}}
\item \code{cat_pages_pdftk()} which wraps \code{pdftk} command-line tool
\item \code{cat_pages_gs()} which wraps \code{ghostscript} command-line tool
}
}
\examples{
if (supports_cat_pages() && require("grid", quietly = TRUE)) {
  # Create two different two-page pdf files
  make_pdf <- function(f, title) {
    pdf(f, onefile = TRUE, title = title)
    grid.text(paste(title, "Page 1"))
    grid.newpage()
    grid.text(paste(title, "Page 2"))
    invisible(dev.off())
  }
  f1 <- tempfile(fileext = "_doc1.pdf")
  on.exit(unlink(f1))
  make_pdf(f1, "Document 1")

  f2 <- tempfile(fileext = "_doc2.pdf")
  on.exit(unlink(f2))
  make_pdf(f2, "Document 2")

  fc <- tempfile(fileext = "_cat.pdf")
  on.exit(unlink(fc))
  cat_pages(c(f1, f2), fc)

  # Use `cat_bookmarks()` to create pdf bookmarks for concatenated output files
  if (supports_get_bookmarks() && supports_set_bookmarks()) {
     l <- get_bookmarks(c(f1, f2))
     bm <- cat_bookmarks(l, "title")
     set_bookmarks(bm, fc)
     print(get_bookmarks(fc)[[1]])
  }
  unlink(f1)
  unlink(f2)
  unlink(fc)
}
}
\seealso{
\code{\link[=supports_cat_pages]{supports_cat_pages()}}, \code{\link[=supports_gs]{supports_gs()}}, and \code{\link[=supports_pdftk]{supports_pdftk()}} to detect support for these features.
\code{\link[=cat_bookmarks]{cat_bookmarks()}} for generating bookmarks for concatenated files.
}
