% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_serialize.R
\name{xml_serialize}
\alias{xml_serialize}
\alias{xml_unserialize}
\title{Serializing XML objects to connections.}
\usage{
xml_serialize(object, connection, ...)

xml_unserialize(connection, ...)
}
\arguments{
\item{object}{\R object to serialize.}

\item{connection}{an open \link{connection} or (for \code{serialize})
    \code{NULL} or (for \code{unserialize}) a raw vector
    (see \sQuote{Details}).}

\item{...}{Additional arguments passed to \code{\link[=read_xml]{read_xml()}}.}
}
\value{
For \code{serialize}, \code{NULL} unless \code{connection = NULL}, when
  the result is returned in a raw vector.

  For \code{unserialize} an \R object.
}
\description{
Serializing XML objects to connections.
}
\examples{
library(xml2)
x <- read_xml("<a>
  <b><c>123</c></b>
  <b><c>456</c></b>
</a>")

b <- xml_find_all(x, "//b")
out <- xml_serialize(b, NULL)
xml_unserialize(out)
}
