% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xml_modify.R
\name{xml_new_document}
\alias{xml_new_document}
\alias{xml_new_root}
\title{Create a new document, possibly with a root node}
\usage{
xml_new_document(version = "1.0", encoding = "UTF-8")

xml_new_root(.value, ..., .copy = inherits(.value, "xml_node"),
  .version = "1.0", .encoding = "UTF-8")
}
\arguments{
\item{version}{The version number of the document.}

\item{encoding}{The character encoding to use in the document. The default
encoding is \sQuote{UTF-8}. Available encodings are specified at
\url{http://xmlsoft.org/html/libxml-encoding.html#xmlCharEncoding}.}

\item{.value}{node to insert.}

\item{...}{If named attributes or namespaces to set on the node, if unnamed
text to assign to the node.}

\item{.copy}{whether to copy the \code{.value} before replacing. If this is \code{FALSE}
then the node will be moved from it's current location.}

\item{.version}{The version number of the document, passed to \code{xml_new_document(version)}.}

\item{.encoding}{The encoding of the document, passed to \code{xml_new_document(encoding)}.}
}
\value{
A \code{xml_document} object.
}
\description{
\code{xml_new_document} creates only a new document without a root node. In
most cases you should instead use \code{xml_new_root}, which creates a new
document and assigns the root node in one step.
}
