% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/galaxy.trimfill.R
\name{dat.gen}
\alias{dat.gen}
\title{Generate  bivariate meta analysis studies}
\usage{
dat.gen(
  m.o,
  m.m,
  s.m,
  angle.LC = pi/4,
  mybeta,
  tau.sq,
  rho.w,
  rho.b,
  s.min = 0.01,
  m.m.o = 0,
  s2.dist = 2,
  verbose = F
)
}
\arguments{
\item{m.o}{number of observed studies}

\item{m.m}{number of missing / suppressed studies}

\item{s.m}{vector of the mean of the variances of the two outcomes}

\item{angle.LC}{direction of suppressing line, default is pi/4, i.e. the studies on the left bottom corner are missing}

\item{mybeta}{the true center of the effect sizes}

\item{tau.sq}{between-study variance, the larger it is the more heterogeneity.}

\item{rho.w}{within-study correlation of the two outcomes}

\item{rho.b}{between-study correlation of the two outcomes}

\item{s.min}{minimum of the variances of the outcomes, default is 0.01}

\item{m.m.o}{number of studies on one side of the suppressing line been observed, 
i.e. non-deterministic suppressing, default is 0, i.e. deterministic suppressing}

\item{s2.dist}{options for generating the outcomes' variances. 1=runif, 2=runif^2, 3=runif^4, 4=rnorm}

\item{verbose}{logical, galaxy plot the studies? Default FALSE}
}
\description{
Generate  bivariate meta analysis studies based on random-effects model, 
              some studies with smallest weighted sum of the two outcomes are suppressed.
}
\references{
Luo C, Marks-Anglin AK, Duan R, Lin L, Hong C, Chu H, Chen Y. Accounting for small-study effects 
               using a bivariate trim and fill meta-analysis procedure. medRxiv. 2020 Jan 1.
}
\author{
Chongliang Luo, Yong Chen
}
