% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getAssets.R
\name{getAssets}
\alias{getAssets}
\title{Returns all assets.}
\usage{
getAssets(limit, cursor = NULL, asset_code = "", asset_issuer = "",
  order = "asc", data.table = TRUE, domain = "public")
}
\arguments{
\item{limit}{numeric - the number of records to return. Default is 10.}

\item{cursor}{numeric - optional, a paging token - where to start from. Can also be "now".}

\item{asset_code}{character - (optional) code of the asset to filter by}

\item{asset_issuer}{character - (optional) issuer of the asset to filter by}

\item{order}{character - optional, "asc" or "desc"}

\item{data.table}{boolean - if TRUE, a data.table is returned. If FALSE or NULL, a list is returned.}

\item{domain}{character - signalling to query the testnet or public network. Can be either "testnet" or "public". boolean - if TRUE, a data.table is overwritten and the server-side streaming capability is utilised. A list will be returned.}
}
\value{
list
}
\description{
Return all assets in the system with statistics.
}
\note{
https://www.stellar.org/developers/horizon/reference/endpoints/assets-all.html
}
\examples{
getAssets(10, domain = "testnet")
}
