% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/paths.R
\name{magic_path}
\alias{magic_path}
\title{Find a file or directory under a root directory}
\usage{
magic_path(
  ...,
  root = proj_root(),
  relative = TRUE,
  error = TRUE,
  message = getOption("xfun.magic_path.message", TRUE),
  n_dirs = getOption("xfun.magic_path.n_dirs", 10000)
)
}
\arguments{
\item{...}{A character vector of path components.}

\item{root}{The root directory under which to search for the path. If
\code{NULL}, the current working directory is used.}

\item{relative}{Whether to return a relative path.}

\item{error}{Whether to signal an error if the path is not found, or multiple
paths are found.}

\item{message}{Whether to emit a message when multiple paths are found and
\code{error = FALSE}.}

\item{n_dirs}{The number of subdirectories to recursively search. The
recursive search may be time-consuming when there are a large number of
subdirectories under the root directory. If you really want to search for
all subdirectories, you may try \code{n_dirs = Inf}.}
}
\value{
The path found under the root directory, or an error when \code{error
  = TRUE} and the path is not found (or multiple paths are found).
}
\description{
Given a path, try to find it recursively under a root directory. The input
path can be an incomplete path, e.g., it can be a base filename, and
\code{magic_path()} will try to find this file under subdirectories.
}
\examples{
\dontrun{
xfun::magic_path("mtcars.csv")  # find any file that has the base name mtcars.csv
}
}
