% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGeneBenchmark.R
\name{runOneBenchmark}
\alias{runOneBenchmark}
\title{Script for testing a single selection functions}
\usage{
runOneBenchmark(name, limit = c(10, 100, 1000), both = TRUE, verbose = FALSE)
}
\arguments{
\item{name}{Name is one of the following strings.

             \enumerate{
             \item "Uniform" benchmarks \code{SelectUniform}.
             \item "ProportionalOnln" benchmarks \code{SelectPropFitOnln}.
             \item "Proportional" benchmarks \code{SelectPropFit}.
             \item "ProportionalM" benchmarks \code{SelectPropFitM}.
             \item "PropFitDiffOnln" benchmarks \code{SelectPropFitDiffOnln}.
             \item "PropFitDiff" benchmarks \code{SelectPropFitDiff}.
             \item "PropFitDiffM" benchmarks \code{SelectPropFitDiffM}.
             \item "Tournament" benchmarks \code{SelectTournament}.
             \item "Duel" benchmarks \code{SelectDuel}.
             \item "LinearRank" benchmarks \code{SelectLinearRank}.
             \item "SUS" benchmarks \code{SelectSUS}.
             }}

\item{limit}{Vector of population sizes.}

\item{both}{For \code{both=TRUE} the selection function 
is benchmarked with and without transformation. 
For \code{both=FALSE}, only the transformed selection functions
are benchmarked.}

\item{verbose}{Boolean. Default: \code{FALSE}. 
If \code{TRUE}, the function benchmarked and the population size 
are printed to the console.}
}
\value{
A data frame sorted in ascending order of time of last column.
}
\description{
Script for testing a single selection functions
}
\section{Warning}{

   The time to run the function for \code{lim>6} explodes 
   for all benchmark functions with higher than linear complexity.
   (e.g. \code{PropFit}, \code{PropFitdiff}, and \code{Tournament}).
}

\examples{
runOneBenchmark("Duel", 5, both=FALSE)
runOneBenchmark("PropFitDiffOnln")
}
\seealso{
Other Benchmark Selection Functions: 
\code{\link{predictSelectTime}()},
\code{\link{runSelectBenchmarks}()},
\code{\link{selectBenchmark}()},
\code{\link{testSelectGene}()}
}
\concept{Benchmark Selection Functions}
