% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/selectGene.R
\name{SelectLinearRankTSR}
\alias{SelectLinearRankTSR}
\title{Linear rank selection.}
\usage{
SelectLinearRankTSR(fit, lF, size = 1)
}
\arguments{
\item{fit}{Fitness vector.}

\item{lF}{Local configuration.}

\item{size}{Size of return vector (default: 1).}
}
\value{
The index vector of selected genes.
}
\description{
\code{SelectLinearRankTSR} implements selection
     with interpolated target sampling rates.
}
\details{
The target sampling rate is a linear interpolation 
         between \code{lF$MaxTSR} and \code{Min<-2-lF$MaxTSR},
         because the sum of the target sampling rates is $n$. 
         The target sampling rates are computed and used as a fitness
         vector for stochastic universal sampling algorithm
         implemented by \code{SelectSUS}.
         \code{lF$MaxTSR} should be in [1.0, 2.0].
              
         TODO: More efficient implementation. We use two sorts!
}
\examples{
fit<-sample(10, 15, replace=TRUE)
SelectLinearRankTSR(fit, NewlFselectGenes()) 
SelectLinearRankTSR(fit, NewlFselectGenes(), length(fit)) 
}
\references{
Grefenstette, John J. and Baker, James E. (1989):
     How Genetic Algorithms Work: A Critical Look at Implicit Parallelism
     In Schaffer, J. David (Ed.) 
     \emph{Proceedings of the Third International 
     Conference on Genetic Algorithms on Genetic Algorithms}, pp. 20-27.
     (ISBN:1-55860-066-3)
}
\seealso{
Other Selection Functions: 
\code{\link{SelectDuel}()},
\code{\link{SelectLRSelective}()},
\code{\link{SelectPropFitDiffM}()},
\code{\link{SelectPropFitDiffOnln}()},
\code{\link{SelectPropFitDiff}()},
\code{\link{SelectPropFitM}()},
\code{\link{SelectPropFitOnln}()},
\code{\link{SelectPropFit}()},
\code{\link{SelectSTournament}()},
\code{\link{SelectSUS}()},
\code{\link{SelectTournament}()},
\code{\link{SelectUniformP}()},
\code{\link{SelectUniform}()}
}
\concept{Selection Functions}
