% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/evalGene.R
\name{EvalGeneFactory}
\alias{EvalGeneFactory}
\title{Configure the evaluation function of a genetic algorithm.}
\usage{
EvalGeneFactory(method = "EvalGeneU")
}
\arguments{
\item{method}{Available methods are: 

\itemize{
\item "EvalGeneU": Evaluate gene (Default).
                   Function \code{EvalGeneU}.
\item "EvalGeneR": If the gene has been repaired by a decoder, 
                   the gene is replaced by the repaired gene.
                   Function \code{EvalGeneR}.
\item "Deterministic": A gene which has been evaluated is 
                       not reevaluated. 
                   Function \code{EvalGeneDet}.
\item "Stochastic": The fitness mean and 
                    the fitness variance
                    are incrementally updated.
                    Genes remaining in the population over several
                    generations, the fitness mean converges to the 
                    expected mean.
                   Function \code{EvalGeneStoch}.
}}
}
\value{
An evaluation function.
}
\description{
\code{EvalGeneFactory} implements the selection 
             of one of the evaluation functions for a gene 
             in this package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error) if the label does not match.
             The functions are specified locally.
}
\examples{
set.seed(5)
DeJongF4<-DeJongF4Factory()
lF<-NewlFevalGenes(DeJongF4)
EvalGene<-EvalGeneFactory("EvalGeneU")
g1<-list(evaluated=FALSE, evalFail=FALSE, fit=0, gene1=c(1.0, -1.5))
g1
g2<-EvalGene(g1, lF)
g2
EvalGene<-EvalGeneFactory("Deterministic")
g3<-EvalGene(g2, lF)
g3
set.seed(5)
EvalGene<-EvalGeneFactory("Stochastic")
g1<-list(evaluated=FALSE, evalFail=FALSE, fit=0, gene1=c(1.0, -1.5))
g1
g2<-EvalGene(g1, lF)
g2
g3<-EvalGene(g2, lF)
g3
}
\seealso{
Other Configuration: 
\code{\link{DispersionMeasureFactory}()},
\code{\link{ScalingFactory}()},
\code{\link{SelectGeneFactory}()}
}
\concept{Configuration}
