% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scaling.R
\name{DispersionRatio}
\alias{DispersionRatio}
\title{Dispersion Ratio}
\usage{
DispersionRatio(popStat, DM, lF)
}
\arguments{
\item{popStat}{Population statistics.}

\item{DM}{Dispersion function.}

\item{lF}{Local configuration.}
}
\value{
Dispersion ratio.
}
\description{
The dispersion ratio is computed as 
     the ratio \code{DM(t)/DM(k)}
     where \code{DM(t)} is the dispersion measure of period t and 
     \code{DM(k)} the dispersion measure of period \code{max(1, (t-k))}.
     \code{k} is specified by \code{lF$ScalingDelay}.
}
\details{
The dispersion ratio may take unreasonably high and low values
         leading to numerical underflow or overflow 
         of fitness values. Therefore,
         we use hard thresholding to force 
         the dispersion ratio into the interval 
         \code{[lF$DRmin(), lF$DRmax()]}.
         The default interval is \code{[0.5, 2.0]}.
}
\examples{
p<-matrix(0, nrow=3, ncol=8)
p[1,]<-c(14.1,  0.283,  5.53, 14.0, 19.4, 38.1, 90.2, 6.54)
p[2,]<-c(20.7,  0.794, 14.63, 19.0, 26.5, 38.8, 71.4, 5.27)
p[3,]<-c(24.0,  6.007, 16.89, 24.1, 29.2, 38.8, 73.4, 6.50)
F<-list()
F$ScalingDelay<-function() {1}
F$DRmax<-function() {2.0}
F$DRmin<-function() {0.5}
dm<-DispersionMeasureFactory("var")
DispersionRatio(p, dm, F)
F$ScalingDelay<-function() {2}
DispersionRatio(p, dm, F)
}
\seealso{
Other Scaling: 
\code{\link{ContinuousScaleFitness}()},
\code{\link{ScaleFitness}()},
\code{\link{ScalingFitness}()},
\code{\link{ThresholdScaleFitness}()}
}
\concept{Scaling}
