% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parModel.R
\name{futureLapply}
\alias{futureLapply}
\title{Future apply of R-package \code{future.apply}.}
\usage{
futureLapply(pop, EvalGene, lF)
}
\arguments{
\item{pop}{Population of genes.}

\item{EvalGene}{Function for evaluating a gene.}

\item{lF}{Local function factory which provides 
all functions needed in \code{EvalGene}.}
}
\value{
Fitness vector.
}
\description{
The \code{lapply()} function is redefined as as 
\code{future.apply::future_lapply()}.
Henrik Bengtsson recommends that the configuration of the 
parallel/distributed programming environment should be kept 
outside the package and left to the user. 
The advantage is that the user may take advantage of all 
parallel/distributed available backends for the Future API.
}
\details{
Be aware that
\itemize{
\item \code{future_lapply()} assumes that each function evaluation 
      need approximately the same time.
\item Best results are obtained 
      if \code{popsize} modulo \code{workers} is \code{0}.
}
}
\examples{
pop<-xegaInitPopulation(1000, lFxegaGaGene)
library(future)
plan(multisession, workers=2)
popnew<-futureLapply(pop, lFxegaGaGene$EvalGene, lFxegaGaGene)
plan(sequential)

}
\references{
Bengtsson H (2021). “A Unifying Framework for Parallel and 
Distributed Processing in R using Futures.” 
The R Journal, 13(2), 208–227. <doi:10.32614/RJ-2021-048>
}
\seealso{
Other Execution Model: 
\code{\link{MClapply}()},
\code{\link{PparLapply}()}
}
\concept{Execution Model}
