% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaGeCodonPrecision.R
\name{xegaGePrecisionFactory}
\alias{xegaGePrecisionFactory}
\title{Configure the function for computing the codon precision for grammar evolution.}
\usage{
xegaGePrecisionFactory(method = "LCM")
}
\arguments{
\item{method}{String specifying the GeneMap function.}
}
\value{
Precision of codon function.
}
\description{
\code{xegaGePrecisionFactory()} implements the selection
             of one of the functions for computing the codon precision in this
             package by specifying a text string.
             The selection fails ungracefully (produces
             a runtime error), if the label does not match.
             The functions are specified locally.

             Current support:

             \enumerate{
             \item "Min" returns \code{MinCodonPrecision}.
                   Shortest coding, but some choice bias.
             \item "LCM" returns \code{mLCMGCodonPrecision}. (Default)
             \item "MaxPBias" returns \code{CodonPrecisionWithThreshold}.
             }
}
\examples{
CodonPrecision<-xegaGePrecisionFactory("Min")
NT<-sample(5, 50, replace=TRUE)
CodonPrecision(NT)
CodonPrecision<-xegaGePrecisionFactory("MaxPBias")
CodonPrecision(NT, 0.1)
}
\seealso{
Other Configuration: 
\code{\link{xegaGeGeneMapFactory}()}
}
\concept{Configuration}
