% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/xegaDfCrossover.R
\name{xegaDfUCrossGene}
\alias{xegaDfUCrossGene}
\title{Uniform crossover of 2 genes.}
\usage{
xegaDfUCrossGene(gg1, gg2, lF)
}
\arguments{
\item{gg1}{Real-coded gene.}

\item{gg2}{Real-coded gene.}

\item{lF}{Local configuration of the genetic algorithm.}
}
\value{
Real-coded gene.
}
\description{
\code{xegaDfUCrossGene()} swaps alleles of both genes
             with a probability of 0.5. It generates a random 
             mask which is used to build the new gene.
}
\examples{
gene1<-xegaDfInitGene(lFxegaDfGene)
gene2<-xegaDfInitGene(lFxegaDfGene)
gene3<-xegaDfUCrossGene(gene1, gene2, lFxegaDfGene)
}
\references{
Syswerda, Gilbert (1989):
  Uniform Crossover in Genetic Algorithms. 
  In: Schaffer, J. David (Ed.)
  Proceedings of the Third International Conference on Genetic Algorithms,
  Morgan Kaufmann Publishers, Los Altos, California, pp. 2-9.
  (ISBN:1-55860-066-3)
}
\seealso{
Other Crossover (Returns 1 Kid): 
\code{\link{xegaDfCrossGene}()},
\code{\link{xegaDfUPCrossGene}()}
}
\concept{Crossover (Returns 1 Kid)}
