% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/color.R
\name{apply_alpha}
\alias{apply_alpha}
\title{Add alpha to hex color}
\usage{
apply_alpha(color_hex, opacity = 0.5)
}
\arguments{
\item{color_hex}{A character string representing a hex color}

\item{opacity}{Desired opacity of the output color}
}
\value{
A character string with added opacity level as hexadecimal characters.
}
\description{
Applies alpha (or opacity) to a color in hexadecimal form by
converting opacity in the \verb{[0, 1]} range to hex in the \verb{[0, 255]} range
and appending to the hex color.
}
\examples{
blue <- "#0e6ba8"
blue_transparent <- apply_alpha(blue)

if (requireNamespace("scales", quietly = TRUE)) {
  scales::show_col(c(blue, blue_transparent))
}
}
