% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wx.R
\name{wx}
\alias{wx}
\title{Runs weather generator}
\usage{
wx(
  trainingData,
  syr = NULL,
  eyr = NULL,
  nsim,
  nrealz,
  aseed,
  wwidth,
  unitSystem,
  ekflag,
  awinFlag,
  tempPerturb,
  parallelize = NULL
)
}
\arguments{
\item{trainingData}{Either a matrix, dataframe, or path to a .csv file with the following variables
is required: year, month, day, prcp (daily precipitation),
 temp (daily temperature),
  and season (1, 2, ..., N, for N seasons - up to 26 seasons will work but seasons need to be defined in a meaningful way).
  Units must be either U.S. Customary (inches, degrees F) or metric (mm, degrees C) and must be specified with
  the `unitSystem` input variable. Input data can be station-based, basin averages, grid cells, etc.
      Input data MUST have these variables: year, month, day, prcp, temp, season.}

\item{syr}{Optional: subset training data to specific start year (defaults to beginning of training data). Subset will begin on the first day available in `syr`.}

\item{eyr}{Optional: subset training data to specific end year (defaults to end of training data). Subset will end on the last day available in `eyr`.}

\item{nsim}{Number of simulation years.}

\item{nrealz}{Number of realizations or traces (i.e., ensemble size).}

\item{aseed}{Specify a seed for reproducibility.}

\item{wwidth}{Set the sampling window for each day of year, a lower value for `wwidth` will sample fewer surrounding days (lower variability) and a higher value will sample more days (higher variability). Typical setting of `wwidth` is between 2 and 15, resulting in a daily sampling window of 5 days and 31 days, respectively.}

\item{unitSystem}{Specify the unit system of your training data. Input a string that is either "U.S. Customary" or "Metric". U.S. Customary corresponds to inches and degrees Farenheit, while Metric corresponds to millimeter and degrees Celsius.
If Metric is specified, units will automatically be converted to U.S. Customary for weather simulation, then re-converted to Metric for results output.}

\item{ekflag}{Simulate outside historical envelope using an Epanechnikov kernel? (T/F)}

\item{awinFlag}{Set to T or TRUE if you would like to see the results of the adaptive window width.
If only one or zero precipitation values (>0.01 inches) are found within the initial window width you set from a day where precipitation occurred,
it will be iteratively increased until two or more precipitation values are found. By default, the results are not shown.}

\item{tempPerturb}{Set to T or TRUE if you would like to add random noise to the
temperature simulations based on a normal distribution fit on the training data.}

\item{parallelize}{Enable parallel computing for precipitation simulation, set T or TRUE to enable. By default, this is turned off.}
}
\value{
Returns a list containing both inputs to the weather generator as well as outputs.
\itemize{
  \item dat.d - User inputs to weather generator, saved for future use.
  \item simyr1 - The years sampled for each trace.
  \item X - The simulated daily dry/wet sequences for each trace (0 = dry, 1 = wet).
  \item Xseas - The simulated season by day for each trace.
  \item Xpdate - If precipitation was simulated to occur on a given day, this is the date from which historical precipitation is sampled.
  \item Xpamt - The simulated daily precipitation depth.
  \item Xtemp - The simulated daily mean temperature.
}
}
\description{
Runs the weather generator based on user inputs.\cr
\cr
Your input/training data MUST have the following variables,
 in this order: year, month, day, prcp, temp, season. These variables are case sensitive
 and must be spelled as specified here.\cr
 \cr
 Your training data should start at the beginning of the calendar year (January 1) as the
 weather simulator is designed for the full calendar year.\cr
 Use starting- and ending- years to subset your input data if desired;
 otherwise starting and ending dates will default to the beginning and end of your dataset.\cr
 \cr
Using 'ekflag = T' will generate simulations outside of the historical envelope
via an Epanechnikov kernel. For more details on the Epanechnikov kernel and its use
in a weather generator, see Rajagopalan et al. (1996).\cr
\cr
 \cr
 Leap years may be included in the simulated weather if they are included in your training data,
 so non-leap years include a row of 'NA' values at the end of the calendar year as a book-keeping
 measure so that the total number of rows in each trace is the same.\cr
 \cr
 The weather generator can handle missing precipitation and temperature data if it is
 marked as `NA` in your training data. It will set `NA` precipitation values to 0 and pass along `NA` temperature values
 if that date is sampled for the simulations. Consider replacing any missing data with monthly or
 daily averages to avoid `NA` values in your simulated weather.
}
\examples{

\donttest{

data(LowerSantaCruzRiverBasinAZ)

head(LowerSantaCruzRiverBasinAZ)

#No input for `syr` because we want the training period to begin at the beginning of the data
#record (1970), but set `eyr` = 1990 because we want to subset training period to end in 1990.

wx(trainingData = LowerSantaCruzRiverBasinAZ,
 eyr = 1990, nsim = 3, nrealz = 3, aseed = 23,
  wwidth = 3, unitSystem = "U.S. Customary",
   ekflag = TRUE, awinFlag = TRUE, tempPerturb = TRUE, parallelize = FALSE)

}

}
